@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property originAccessIdentity The CloudFront origin access identity to associate with the origin.
 */
public data class DistributionOriginS3OriginConfigArgs(
    public val originAccessIdentity: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs.builder()
            .originAccessIdentity(originAccessIdentity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionOriginS3OriginConfigArgs].
 */
@PulumiTagMarker
public class DistributionOriginS3OriginConfigArgsBuilder internal constructor() {
    private var originAccessIdentity: Output<String>? = null

    /**
     * @param value The CloudFront origin access identity to associate with the origin.
     */
    @JvmName("dadaeixbvwilwngj")
    public suspend fun originAccessIdentity(`value`: Output<String>) {
        this.originAccessIdentity = value
    }

    /**
     * @param value The CloudFront origin access identity to associate with the origin.
     */
    @JvmName("fbgytyqwirolmryv")
    public suspend fun originAccessIdentity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originAccessIdentity = mapped
    }

    internal fun build(): DistributionOriginS3OriginConfigArgs = DistributionOriginS3OriginConfigArgs(
        originAccessIdentity = originAccessIdentity ?: throw
            PulumiNullFieldException("originAccessIdentity"),
    )
}
