@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property geoRestriction
 */
public data class DistributionRestrictionsArgs(
    public val geoRestriction: Output<DistributionRestrictionsGeoRestrictionArgs>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs.builder()
            .geoRestriction(
                geoRestriction.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DistributionRestrictionsArgs].
 */
@PulumiTagMarker
public class DistributionRestrictionsArgsBuilder internal constructor() {
    private var geoRestriction: Output<DistributionRestrictionsGeoRestrictionArgs>? = null

    /**
     * @param value
     */
    @JvmName("ilepjynlwqvqgfyo")
    public suspend fun geoRestriction(`value`: Output<DistributionRestrictionsGeoRestrictionArgs>) {
        this.geoRestriction = value
    }

    /**
     * @param value
     */
    @JvmName("ayqxicryymmqhnmf")
    public suspend fun geoRestriction(`value`: DistributionRestrictionsGeoRestrictionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoRestriction = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dpoxbqjmiabacqit")
    public suspend
    fun geoRestriction(argument: suspend DistributionRestrictionsGeoRestrictionArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionRestrictionsGeoRestrictionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.geoRestriction = mapped
    }

    internal fun build(): DistributionRestrictionsArgs = DistributionRestrictionsArgs(
        geoRestriction = geoRestriction ?: throw PulumiNullFieldException("geoRestriction"),
    )
}
