@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property contentTypeProfiles Object that contains an attribute `items` that contains the list of configurations for a field-level encryption content type-profile. See Content Type Profile.
 * @property forwardWhenContentTypeIsUnknown specifies what to do when an unknown content type is provided for the profile. If true, content is forwarded without being encrypted when the content type is unknown. If false (the default), an error is returned when the content type is unknown.
 */
public data class FieldLevelEncryptionConfigContentTypeProfileConfigArgs(
    public val contentTypeProfiles:
    Output<FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs>,
    public val forwardWhenContentTypeIsUnknown: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs =
        com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs.builder()
            .contentTypeProfiles(
                contentTypeProfiles.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .forwardWhenContentTypeIsUnknown(
                forwardWhenContentTypeIsUnknown.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [FieldLevelEncryptionConfigContentTypeProfileConfigArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionConfigContentTypeProfileConfigArgsBuilder internal constructor() {
    private var contentTypeProfiles:
        Output<FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs>? = null

    private var forwardWhenContentTypeIsUnknown: Output<Boolean>? = null

    /**
     * @param value Object that contains an attribute `items` that contains the list of configurations for a field-level encryption content type-profile. See Content Type Profile.
     */
    @JvmName("vidretcmopiwbooe")
    public suspend
    fun contentTypeProfiles(`value`: Output<FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs>) {
        this.contentTypeProfiles = value
    }

    /**
     * @param value specifies what to do when an unknown content type is provided for the profile. If true, content is forwarded without being encrypted when the content type is unknown. If false (the default), an error is returned when the content type is unknown.
     */
    @JvmName("nexqnjcanhbghhnv")
    public suspend fun forwardWhenContentTypeIsUnknown(`value`: Output<Boolean>) {
        this.forwardWhenContentTypeIsUnknown = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains the list of configurations for a field-level encryption content type-profile. See Content Type Profile.
     */
    @JvmName("ctslqwomglhsyyju")
    public suspend
    fun contentTypeProfiles(`value`: FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentTypeProfiles = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains the list of configurations for a field-level encryption content type-profile. See Content Type Profile.
     */
    @JvmName("rawkmbkqpemsvnbr")
    public suspend
    fun contentTypeProfiles(argument: suspend FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgsBuilder.() -> Unit) {
        val toBeMapped =
            FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.contentTypeProfiles = mapped
    }

    /**
     * @param value specifies what to do when an unknown content type is provided for the profile. If true, content is forwarded without being encrypted when the content type is unknown. If false (the default), an error is returned when the content type is unknown.
     */
    @JvmName("djuvlvftekkttuok")
    public suspend fun forwardWhenContentTypeIsUnknown(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardWhenContentTypeIsUnknown = mapped
    }

    internal fun build(): FieldLevelEncryptionConfigContentTypeProfileConfigArgs =
        FieldLevelEncryptionConfigContentTypeProfileConfigArgs(
            contentTypeProfiles = contentTypeProfiles ?: throw PulumiNullFieldException("contentTypeProfiles"),
            forwardWhenContentTypeIsUnknown = forwardWhenContentTypeIsUnknown ?: throw
                PulumiNullFieldException("forwardWhenContentTypeIsUnknown"),
        )
}
