@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property forwardWhenQueryArgProfileIsUnknown Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument, fle-profile, is unknown.
 * @property queryArgProfiles Object that contains an attribute `items` that contains the list ofrofiles specified for query argument-profile mapping for field-level encryption. see Query Arg Profile.
 */
public data class FieldLevelEncryptionConfigQueryArgProfileConfigArgs(
    public val forwardWhenQueryArgProfileIsUnknown: Output<Boolean>,
    public val queryArgProfiles:
    Output<FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs =
        com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs.builder()
            .forwardWhenQueryArgProfileIsUnknown(
                forwardWhenQueryArgProfileIsUnknown.applyValue({ args0 ->
                    args0
                }),
            )
            .queryArgProfiles(
                queryArgProfiles?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FieldLevelEncryptionConfigQueryArgProfileConfigArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionConfigQueryArgProfileConfigArgsBuilder internal constructor() {
    private var forwardWhenQueryArgProfileIsUnknown: Output<Boolean>? = null

    private var queryArgProfiles:
        Output<FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs>? = null

    /**
     * @param value Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument, fle-profile, is unknown.
     */
    @JvmName("idfoktkdosnivuwi")
    public suspend fun forwardWhenQueryArgProfileIsUnknown(`value`: Output<Boolean>) {
        this.forwardWhenQueryArgProfileIsUnknown = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains the list ofrofiles specified for query argument-profile mapping for field-level encryption. see Query Arg Profile.
     */
    @JvmName("axcnyukjirdyfhao")
    public suspend
    fun queryArgProfiles(`value`: Output<FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs>) {
        this.queryArgProfiles = value
    }

    /**
     * @param value Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument, fle-profile, is unknown.
     */
    @JvmName("bqohqjvsrnddnkol")
    public suspend fun forwardWhenQueryArgProfileIsUnknown(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardWhenQueryArgProfileIsUnknown = mapped
    }

    /**
     * @param value Object that contains an attribute `items` that contains the list ofrofiles specified for query argument-profile mapping for field-level encryption. see Query Arg Profile.
     */
    @JvmName("usyxdmolmntdndxv")
    public suspend
    fun queryArgProfiles(`value`: FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryArgProfiles = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains the list ofrofiles specified for query argument-profile mapping for field-level encryption. see Query Arg Profile.
     */
    @JvmName("wmnfirjjslemdype")
    public suspend
    fun queryArgProfiles(argument: suspend FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgsBuilder.() -> Unit) {
        val toBeMapped =
            FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryArgProfiles = mapped
    }

    internal fun build(): FieldLevelEncryptionConfigQueryArgProfileConfigArgs =
        FieldLevelEncryptionConfigQueryArgProfileConfigArgs(
            forwardWhenQueryArgProfileIsUnknown = forwardWhenQueryArgProfileIsUnknown ?: throw
                PulumiNullFieldException("forwardWhenQueryArgProfileIsUnknown"),
            queryArgProfiles = queryArgProfiles,
        )
}
