@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetLogDeliveryCanonicalUserIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLogDeliveryCanonicalUserId.
 * @property region Region you'd like the zone for. By default, fetches the current region.
 */
public data class GetLogDeliveryCanonicalUserIdPlainArgs(
    public val region: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetLogDeliveryCanonicalUserIdPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetLogDeliveryCanonicalUserIdPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetLogDeliveryCanonicalUserIdPlainArgs.builder()
            .region(region?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogDeliveryCanonicalUserIdPlainArgs].
 */
@PulumiTagMarker
public class GetLogDeliveryCanonicalUserIdPlainArgsBuilder internal constructor() {
    private var region: String? = null

    /**
     * @param value Region you'd like the zone for. By default, fetches the current region.
     */
    @JvmName("lcmmejopydmgqvxa")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    internal fun build(): GetLogDeliveryCanonicalUserIdPlainArgs =
        GetLogDeliveryCanonicalUserIdPlainArgs(
            region = region,
        )
}
