@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOriginAccessIdentities.
 * @property comments Filter origin access identities by comment.
 */
public data class GetOriginAccessIdentitiesPlainArgs(
    public val comments: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesPlainArgs.builder()
            .comments(comments?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetOriginAccessIdentitiesPlainArgs].
 */
@PulumiTagMarker
public class GetOriginAccessIdentitiesPlainArgsBuilder internal constructor() {
    private var comments: List<String>? = null

    /**
     * @param value Filter origin access identities by comment.
     */
    @JvmName("fapgsccyjkfcqpdx")
    public suspend fun comments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.comments = mapped
    }

    /**
     * @param values Filter origin access identities by comment.
     */
    @JvmName("qdnidrrrhqggbfvh")
    public suspend fun comments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.comments = mapped
    }

    internal fun build(): GetOriginAccessIdentitiesPlainArgs = GetOriginAccessIdentitiesPlainArgs(
        comments = comments,
    )
}
