@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOriginRequestPolicy.
 * @property id Identifier for the origin request policy.
 * @property name Unique name to identify the origin request policy.
 */
public data class GetOriginRequestPolicyPlainArgs(
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyPlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOriginRequestPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetOriginRequestPolicyPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    /**
     * @param value Identifier for the origin request policy.
     */
    @JvmName("cbryxuddnuwvuocp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Unique name to identify the origin request policy.
     */
    @JvmName("swrfiylctijccslj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetOriginRequestPolicyPlainArgs = GetOriginRequestPolicyPlainArgs(
        id = id,
        name = name,
    )
}
