@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property realtimeMetricsSubscriptionConfig A subscription configuration for additional CloudWatch metrics. See below.
 */
public data class MonitoringSubscriptionMonitoringSubscriptionArgs(
    public val realtimeMetricsSubscriptionConfig:
    Output<MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs =
        com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs.builder()
            .realtimeMetricsSubscriptionConfig(
                realtimeMetricsSubscriptionConfig.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [MonitoringSubscriptionMonitoringSubscriptionArgs].
 */
@PulumiTagMarker
public class MonitoringSubscriptionMonitoringSubscriptionArgsBuilder internal constructor() {
    private var realtimeMetricsSubscriptionConfig:
        Output<MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs>? =
        null

    /**
     * @param value A subscription configuration for additional CloudWatch metrics. See below.
     */
    @JvmName("afokphmgujsydksn")
    public suspend
    fun realtimeMetricsSubscriptionConfig(`value`: Output<MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs>) {
        this.realtimeMetricsSubscriptionConfig = value
    }

    /**
     * @param value A subscription configuration for additional CloudWatch metrics. See below.
     */
    @JvmName("yyvxcaxoeeisbisy")
    public suspend
    fun realtimeMetricsSubscriptionConfig(`value`: MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.realtimeMetricsSubscriptionConfig = mapped
    }

    /**
     * @param argument A subscription configuration for additional CloudWatch metrics. See below.
     */
    @JvmName("pehqsfahxoicfblo")
    public suspend
    fun realtimeMetricsSubscriptionConfig(argument: suspend MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.realtimeMetricsSubscriptionConfig = mapped
    }

    internal fun build(): MonitoringSubscriptionMonitoringSubscriptionArgs =
        MonitoringSubscriptionMonitoringSubscriptionArgs(
            realtimeMetricsSubscriptionConfig = realtimeMetricsSubscriptionConfig ?: throw
                PulumiNullFieldException("realtimeMetricsSubscriptionConfig"),
        )
}
