@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property headerBehavior
 * @property headers
 */
public data class OriginRequestPolicyHeadersConfigArgs(
    public val headerBehavior: Output<String>? = null,
    public val headers: Output<OriginRequestPolicyHeadersConfigHeadersArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigArgs =
        com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigArgs.builder()
            .headerBehavior(headerBehavior?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OriginRequestPolicyHeadersConfigArgs].
 */
@PulumiTagMarker
public class OriginRequestPolicyHeadersConfigArgsBuilder internal constructor() {
    private var headerBehavior: Output<String>? = null

    private var headers: Output<OriginRequestPolicyHeadersConfigHeadersArgs>? = null

    /**
     * @param value
     */
    @JvmName("yporkkcwqfnqivdj")
    public suspend fun headerBehavior(`value`: Output<String>) {
        this.headerBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("lmrxgkaqevqwoikb")
    public suspend fun headers(`value`: Output<OriginRequestPolicyHeadersConfigHeadersArgs>) {
        this.headers = value
    }

    /**
     * @param value
     */
    @JvmName("qvfyvgphawrcrbmr")
    public suspend fun headerBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("wvufvbcpdppdfefu")
    public suspend fun headers(`value`: OriginRequestPolicyHeadersConfigHeadersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yvfokflcfmginhgt")
    public suspend
    fun headers(argument: suspend OriginRequestPolicyHeadersConfigHeadersArgsBuilder.() -> Unit) {
        val toBeMapped = OriginRequestPolicyHeadersConfigHeadersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    internal fun build(): OriginRequestPolicyHeadersConfigArgs = OriginRequestPolicyHeadersConfigArgs(
        headerBehavior = headerBehavior,
        headers = headers,
    )
}
