@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property items
 */
public data class ResponseHeadersPolicyCustomHeadersConfigArgs(
    public val items: Output<List<ResponseHeadersPolicyCustomHeadersConfigItemArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs.builder()
            .items(
                items?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResponseHeadersPolicyCustomHeadersConfigArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyCustomHeadersConfigArgsBuilder internal constructor() {
    private var items: Output<List<ResponseHeadersPolicyCustomHeadersConfigItemArgs>>? = null

    /**
     * @param value
     */
    @JvmName("ibdcyanscxxghwvb")
    public suspend
    fun items(`value`: Output<List<ResponseHeadersPolicyCustomHeadersConfigItemArgs>>) {
        this.items = value
    }

    @JvmName("lbcxkaaoklcwukmy")
    public suspend fun items(
        vararg
        values: Output<ResponseHeadersPolicyCustomHeadersConfigItemArgs>,
    ) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yjiqppxuiqvadedc")
    public suspend fun items(values: List<Output<ResponseHeadersPolicyCustomHeadersConfigItemArgs>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ewstqqrdssuaftqn")
    public suspend fun items(`value`: List<ResponseHeadersPolicyCustomHeadersConfigItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vdmnxmqnxqbinxhs")
    public suspend
    fun items(argument: List<suspend ResponseHeadersPolicyCustomHeadersConfigItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResponseHeadersPolicyCustomHeadersConfigItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eoeqrmjvmieghmji")
    public suspend fun items(
        vararg
        argument: suspend ResponseHeadersPolicyCustomHeadersConfigItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResponseHeadersPolicyCustomHeadersConfigItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nkivocipabpihsui")
    public suspend
    fun items(argument: suspend ResponseHeadersPolicyCustomHeadersConfigItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResponseHeadersPolicyCustomHeadersConfigItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param values
     */
    @JvmName("nhvkdnnpyogtfbeo")
    public suspend fun items(vararg values: ResponseHeadersPolicyCustomHeadersConfigItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    internal fun build(): ResponseHeadersPolicyCustomHeadersConfigArgs =
        ResponseHeadersPolicyCustomHeadersConfigArgs(
            items = items,
        )
}
