@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property header The HTTP response header name.
 * @property override Whether CloudFront overrides the `Content-Security-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
 * @property value The value for the HTTP response header.
 */
public data class ResponseHeadersPolicyCustomHeadersConfigItemArgs(
    public val `header`: Output<String>,
    public val `override`: Output<Boolean>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigItemArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigItemArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder()
            .`header`(`header`.applyValue({ args0 -> args0 }))
            .`override`(`override`.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicyCustomHeadersConfigItemArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyCustomHeadersConfigItemArgsBuilder internal constructor() {
    private var `header`: Output<String>? = null

    private var `override`: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The HTTP response header name.
     */
    @JvmName("bhpnpkcjymefqauc")
    public suspend fun `header`(`value`: Output<String>) {
        this.`header` = value
    }

    /**
     * @param value Whether CloudFront overrides the `Content-Security-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("xvsbmpkjicjklwue")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value The value for the HTTP response header.
     */
    @JvmName("semrtdhklxkenmju")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The HTTP response header name.
     */
    @JvmName("fxbgagqhoseqqjwj")
    public suspend fun `header`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Whether CloudFront overrides the `Content-Security-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("inqxaobfehkrxpvp")
    public suspend fun `override`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    /**
     * @param value The value for the HTTP response header.
     */
    @JvmName("arvlhufpflluapxf")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ResponseHeadersPolicyCustomHeadersConfigItemArgs =
        ResponseHeadersPolicyCustomHeadersConfigItemArgs(
            `header` = `header` ?: throw PulumiNullFieldException("header"),
            `override` = `override` ?: throw PulumiNullFieldException("override"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
