@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property items
 */
public data class ResponseHeadersPolicyRemoveHeadersConfigArgs(
    public val items: Output<List<ResponseHeadersPolicyRemoveHeadersConfigItemArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgs.builder()
            .items(
                items?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResponseHeadersPolicyRemoveHeadersConfigArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyRemoveHeadersConfigArgsBuilder internal constructor() {
    private var items: Output<List<ResponseHeadersPolicyRemoveHeadersConfigItemArgs>>? = null

    /**
     * @param value
     */
    @JvmName("cfptprvhswdhchwb")
    public suspend
    fun items(`value`: Output<List<ResponseHeadersPolicyRemoveHeadersConfigItemArgs>>) {
        this.items = value
    }

    @JvmName("wehvschpnaudwfoc")
    public suspend fun items(
        vararg
        values: Output<ResponseHeadersPolicyRemoveHeadersConfigItemArgs>,
    ) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vjosffjauuskohnb")
    public suspend fun items(values: List<Output<ResponseHeadersPolicyRemoveHeadersConfigItemArgs>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qsmtphdilkuwcwwk")
    public suspend fun items(`value`: List<ResponseHeadersPolicyRemoveHeadersConfigItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gpnbassxipiqmeid")
    public suspend
    fun items(argument: List<suspend ResponseHeadersPolicyRemoveHeadersConfigItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResponseHeadersPolicyRemoveHeadersConfigItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yupnusyolqwsaggo")
    public suspend fun items(
        vararg
        argument: suspend ResponseHeadersPolicyRemoveHeadersConfigItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResponseHeadersPolicyRemoveHeadersConfigItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ealawelrmlmtqlte")
    public suspend
    fun items(argument: suspend ResponseHeadersPolicyRemoveHeadersConfigItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResponseHeadersPolicyRemoveHeadersConfigItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param values
     */
    @JvmName("rtccagnvbmvlgkcx")
    public suspend fun items(vararg values: ResponseHeadersPolicyRemoveHeadersConfigItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    internal fun build(): ResponseHeadersPolicyRemoveHeadersConfigArgs =
        ResponseHeadersPolicyRemoveHeadersConfigArgs(
            items = items,
        )
}
