@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property override Whether CloudFront overrides the `X-Content-Type-Options` HTTP response header received from the origin with the one specified in this response headers policy.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs(
    public val `override`: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs.builder()
            .`override`(`override`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgsBuilder internal
constructor() {
    private var `override`: Output<Boolean>? = null

    /**
     * @param value Whether CloudFront overrides the `X-Content-Type-Options` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("visuvnmfrhktukpn")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value Whether CloudFront overrides the `X-Content-Type-Options` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("qubaplpxlyahnhbu")
    public suspend fun `override`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    internal fun build(): ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs =
        ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs(
            `override` = `override` ?: throw PulumiNullFieldException("override"),
        )
}
