@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property override Whether CloudFront overrides the `Referrer-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
 * @property referrerPolicy The value of the `Referrer-Policy` HTTP response header. Valid Values: `no-referrer` | `no-referrer-when-downgrade` | `origin` | `origin-when-cross-origin` | `same-origin` | `strict-origin` | `strict-origin-when-cross-origin` | `unsafe-url`
 */
public data class ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs(
    public val `override`: Output<Boolean>,
    public val referrerPolicy: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs.builder()
            .`override`(`override`.applyValue({ args0 -> args0 }))
            .referrerPolicy(referrerPolicy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgsBuilder internal
constructor() {
    private var `override`: Output<Boolean>? = null

    private var referrerPolicy: Output<String>? = null

    /**
     * @param value Whether CloudFront overrides the `Referrer-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("nsjirugitqfefkah")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value The value of the `Referrer-Policy` HTTP response header. Valid Values: `no-referrer` | `no-referrer-when-downgrade` | `origin` | `origin-when-cross-origin` | `same-origin` | `strict-origin` | `strict-origin-when-cross-origin` | `unsafe-url`
     */
    @JvmName("ejqrfhtydljobisr")
    public suspend fun referrerPolicy(`value`: Output<String>) {
        this.referrerPolicy = value
    }

    /**
     * @param value Whether CloudFront overrides the `Referrer-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("mlielpcmvqvcvufp")
    public suspend fun `override`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    /**
     * @param value The value of the `Referrer-Policy` HTTP response header. Valid Values: `no-referrer` | `no-referrer-when-downgrade` | `origin` | `origin-when-cross-origin` | `same-origin` | `strict-origin` | `strict-origin-when-cross-origin` | `unsafe-url`
     */
    @JvmName("kdkdrltxuwuecrgj")
    public suspend fun referrerPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referrerPolicy = mapped
    }

    internal fun build(): ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs =
        ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs(
            `override` = `override` ?: throw PulumiNullFieldException("override"),
            referrerPolicy = referrerPolicy ?: throw PulumiNullFieldException("referrerPolicy"),
        )
}
