@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property modeBlock Whether CloudFront includes the `mode=block` directive in the `X-XSS-Protection` header.
 * @property override Whether CloudFront overrides the `X-XSS-Protection` HTTP response header received from the origin with the one specified in this response headers policy.
 * @property protection A Boolean value that determines the value of the `X-XSS-Protection` HTTP response header. When this setting is `true`, the value of the `X-XSS-Protection` header is `1`. When this setting is `false`, the value of the `X-XSS-Protection` header is `0`.
 * @property reportUri A reporting URI, which CloudFront uses as the value of the report directive in the `X-XSS-Protection` header. You cannot specify a `report_uri` when `mode_block` is `true`.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs(
    public val modeBlock: Output<Boolean>? = null,
    public val `override`: Output<Boolean>,
    public val protection: Output<Boolean>,
    public val reportUri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs.builder()
            .modeBlock(modeBlock?.applyValue({ args0 -> args0 }))
            .`override`(`override`.applyValue({ args0 -> args0 }))
            .protection(protection.applyValue({ args0 -> args0 }))
            .reportUri(reportUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgsBuilder internal
constructor() {
    private var modeBlock: Output<Boolean>? = null

    private var `override`: Output<Boolean>? = null

    private var protection: Output<Boolean>? = null

    private var reportUri: Output<String>? = null

    /**
     * @param value Whether CloudFront includes the `mode=block` directive in the `X-XSS-Protection` header.
     */
    @JvmName("ghakeldfjgojomaw")
    public suspend fun modeBlock(`value`: Output<Boolean>) {
        this.modeBlock = value
    }

    /**
     * @param value Whether CloudFront overrides the `X-XSS-Protection` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("jseahxluksjijmfp")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value A Boolean value that determines the value of the `X-XSS-Protection` HTTP response header. When this setting is `true`, the value of the `X-XSS-Protection` header is `1`. When this setting is `false`, the value of the `X-XSS-Protection` header is `0`.
     */
    @JvmName("cqwjvnnwauorkhoa")
    public suspend fun protection(`value`: Output<Boolean>) {
        this.protection = value
    }

    /**
     * @param value A reporting URI, which CloudFront uses as the value of the report directive in the `X-XSS-Protection` header. You cannot specify a `report_uri` when `mode_block` is `true`.
     */
    @JvmName("nscupisxstqobtrh")
    public suspend fun reportUri(`value`: Output<String>) {
        this.reportUri = value
    }

    /**
     * @param value Whether CloudFront includes the `mode=block` directive in the `X-XSS-Protection` header.
     */
    @JvmName("dexepiiejcsgvkat")
    public suspend fun modeBlock(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modeBlock = mapped
    }

    /**
     * @param value Whether CloudFront overrides the `X-XSS-Protection` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("ewwcnepkelgbprvc")
    public suspend fun `override`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    /**
     * @param value A Boolean value that determines the value of the `X-XSS-Protection` HTTP response header. When this setting is `true`, the value of the `X-XSS-Protection` header is `1`. When this setting is `false`, the value of the `X-XSS-Protection` header is `0`.
     */
    @JvmName("sxsboccxvegobtyg")
    public suspend fun protection(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protection = mapped
    }

    /**
     * @param value A reporting URI, which CloudFront uses as the value of the report directive in the `X-XSS-Protection` header. You cannot specify a `report_uri` when `mode_block` is `true`.
     */
    @JvmName("driqydmwctobdusl")
    public suspend fun reportUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportUri = mapped
    }

    internal fun build(): ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs =
        ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs(
            modeBlock = modeBlock,
            `override` = `override` ?: throw PulumiNullFieldException("override"),
            protection = protection ?: throw PulumiNullFieldException("protection"),
            reportUri = reportUri,
        )
}
