@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cookieBehavior Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `cookie_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
 * @property cookies Object that contains a list of cookie names. See Items for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig(
    public val cookieBehavior: String,
    public val cookies: CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookies? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig):
            CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig =
            CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfig(
                cookieBehavior = javaType.cookieBehavior(),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
