@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property items A list of CloudFront domain names for the staging distribution.
 * @property quantity Number of CloudFront domain names in the staging distribution.
 */
public data class ContinuousDeploymentPolicyStagingDistributionDnsNames(
    public val items: List<String>? = null,
    public val quantity: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ContinuousDeploymentPolicyStagingDistributionDnsNames):
            ContinuousDeploymentPolicyStagingDistributionDnsNames =
            ContinuousDeploymentPolicyStagingDistributionDnsNames(
                items = javaType.items().map({ args0 -> args0 }),
                quantity = javaType.quantity(),
            )
    }
}
