@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property singleHeaderConfig Determines which HTTP requests are sent to the staging distribution. See `single_header_config`.
 * @property singleWeightConfig Contains the percentage of traffic to send to the staging distribution. See `single_weight_config`.
 * @property type Type of traffic configuration. Valid values are `SingleWeight` and `SingleHeader`.
 */
public data class ContinuousDeploymentPolicyTrafficConfig(
    public val singleHeaderConfig: ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfig? = null,
    public val singleWeightConfig: ContinuousDeploymentPolicyTrafficConfigSingleWeightConfig? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ContinuousDeploymentPolicyTrafficConfig):
            ContinuousDeploymentPolicyTrafficConfig = ContinuousDeploymentPolicyTrafficConfig(
            singleHeaderConfig = javaType.singleHeaderConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            singleWeightConfig = javaType.singleWeightConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
