@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property idleTtl The amount of time in seconds after which sessions will cease if no requests are received. Valid values are `300` – `3600` (5–60 minutes). The value must be less than or equal to `maximum_ttl`.
 * @property maximumTtl The maximum amount of time in seconds to consider requests from the viewer as being part of the same session. Valid values are `300` – `3600` (5–60 minutes). The value must be greater than or equal to `idle_ttl`.
 */
public data class ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfig(
    public val idleTtl: Int,
    public val maximumTtl: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfig):
            ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfig =
            ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfig(
                idleTtl = javaType.idleTtl(),
                maximumTtl = javaType.maximumTtl(),
            )
    }
}
