@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property errorCachingMinTtl Minimum amount of time you want HTTP error codes to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated.
 * @property errorCode 4xx or 5xx HTTP status code that you want to customize.
 * @property responseCode HTTP status code that you want CloudFront to return with the custom error page to the viewer.
 * @property responsePagePath Path of the custom error page (for example, `/custom_404.html`).
 */
public data class DistributionCustomErrorResponse(
    public val errorCachingMinTtl: Int? = null,
    public val errorCode: Int,
    public val responseCode: Int? = null,
    public val responsePagePath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionCustomErrorResponse):
            DistributionCustomErrorResponse = DistributionCustomErrorResponse(
            errorCachingMinTtl = javaType.errorCachingMinTtl().map({ args0 -> args0 }).orElse(null),
            errorCode = javaType.errorCode(),
            responseCode = javaType.responseCode().map({ args0 -> args0 }).orElse(null),
            responsePagePath = javaType.responsePagePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
