@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property forward Whether you want CloudFront to forward cookies to the origin that is associated with this cache behavior. You can specify `all`, `none` or `whitelist`. If `whitelist`, you must include the subsequent `whitelisted_names`.
 * @property whitelistedNames If you have specified `whitelist` to `forward`, the whitelisted cookies that you want CloudFront to forward to your origin.
 */
public data class DistributionDefaultCacheBehaviorForwardedValuesCookies(
    public val forward: String,
    public val whitelistedNames: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionDefaultCacheBehaviorForwardedValuesCookies):
            DistributionDefaultCacheBehaviorForwardedValuesCookies =
            DistributionDefaultCacheBehaviorForwardedValuesCookies(
                forward = javaType.forward(),
                whitelistedNames = javaType.whitelistedNames().map({ args0 -> args0 }),
            )
    }
}
