@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eventType Specific event to trigger this function. Valid values: `viewer-request`, `origin-request`, `viewer-response`, `origin-response`.
 * @property includeBody When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
 * @property lambdaArn ARN of the Lambda function.
 */
public data class DistributionDefaultCacheBehaviorLambdaFunctionAssociation(
    public val eventType: String,
    public val includeBody: Boolean? = null,
    public val lambdaArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionDefaultCacheBehaviorLambdaFunctionAssociation):
            DistributionDefaultCacheBehaviorLambdaFunctionAssociation =
            DistributionDefaultCacheBehaviorLambdaFunctionAssociation(
                eventType = javaType.eventType(),
                includeBody = javaType.includeBody().map({ args0 -> args0 }).orElse(null),
                lambdaArn = javaType.lambdaArn(),
            )
    }
}
