@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
 * @property includeCookies Whether to include cookies in access logs (default: `false`).
 * @property prefix Prefix to the access log filenames for this distribution, for example, `myprefix/`.
 */
public data class DistributionLoggingConfig(
    public val bucket: String,
    public val includeCookies: Boolean? = null,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionLoggingConfig):
            DistributionLoggingConfig = DistributionLoggingConfig(
            bucket = javaType.bucket(),
            includeCookies = javaType.includeCookies().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
