@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eventType Specific event to trigger this function. Valid values: `viewer-request` or `viewer-response`.
 * @property functionArn ARN of the CloudFront function.
 */
public data class DistributionOrderedCacheBehaviorFunctionAssociation(
    public val eventType: String,
    public val functionArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionOrderedCacheBehaviorFunctionAssociation):
            DistributionOrderedCacheBehaviorFunctionAssociation =
            DistributionOrderedCacheBehaviorFunctionAssociation(
                eventType = javaType.eventType(),
                functionArn = javaType.functionArn(),
            )
    }
}
