@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionAttempts Number of times that CloudFront attempts to connect to the origin. Must be between 1-3. Defaults to 3.
 * @property connectionTimeout Number of seconds that CloudFront waits when trying to establish a connection to the origin. Must be between 1-10. Defaults to 10.
 * @property customHeaders One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
 * @property customOriginConfig The CloudFront custom origin configuration information. If an S3 origin is required, use `origin_access_control_id` or `s3_origin_config` instead.
 * @property domainName DNS domain name of either the S3 bucket, or web site of your custom origin.
 * @property originAccessControlId Unique identifier of a [CloudFront origin access control][8] for this origin.
 * @property originId Unique identifier of the member origin.
 * @property originPath Optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.
 * @property originShield CloudFront Origin Shield configuration information. Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the Amazon CloudFront Developer Guide.
 * @property s3OriginConfig CloudFront S3 origin configuration information. If a custom origin is required, use `custom_origin_config` instead.
 */
public data class DistributionOrigin(
    public val connectionAttempts: Int? = null,
    public val connectionTimeout: Int? = null,
    public val customHeaders: List<DistributionOriginCustomHeader>? = null,
    public val customOriginConfig: DistributionOriginCustomOriginConfig? = null,
    public val domainName: String,
    public val originAccessControlId: String? = null,
    public val originId: String,
    public val originPath: String? = null,
    public val originShield: DistributionOriginOriginShield? = null,
    public val s3OriginConfig: DistributionOriginS3OriginConfig? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionOrigin):
            DistributionOrigin = DistributionOrigin(
            connectionAttempts = javaType.connectionAttempts().map({ args0 -> args0 }).orElse(null),
            connectionTimeout = javaType.connectionTimeout().map({ args0 -> args0 }).orElse(null),
            customHeaders = javaType.customHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginCustomHeader.Companion.toKotlin(args0)
                })
            }),
            customOriginConfig = javaType.customOriginConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginCustomOriginConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            domainName = javaType.domainName(),
            originAccessControlId = javaType.originAccessControlId().map({ args0 -> args0 }).orElse(null),
            originId = javaType.originId(),
            originPath = javaType.originPath().map({ args0 -> args0 }).orElse(null),
            originShield = javaType.originShield().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginOriginShield.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3OriginConfig = javaType.s3OriginConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginS3OriginConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
