@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property failoverCriteria The failover criteria for when to failover to the secondary origin.
 * @property members Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
 * @property originId Unique identifier of the member origin.
 */
public data class DistributionOriginGroup(
    public val failoverCriteria: DistributionOriginGroupFailoverCriteria,
    public val members: List<DistributionOriginGroupMember>,
    public val originId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionOriginGroup):
            DistributionOriginGroup = DistributionOriginGroup(
            failoverCriteria = javaType.failoverCriteria().let({ args0 ->
                com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginGroupFailoverCriteria.Companion.toKotlin(args0)
            }),
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginGroupMember.Companion.toKotlin(args0)
                })
            }),
            originId = javaType.originId(),
        )
    }
}
