@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether Origin Shield is enabled.
 * @property originShieldRegion AWS Region for Origin Shield. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as `us-east-2`.
 */
public data class DistributionOriginOriginShield(
    public val enabled: Boolean,
    public val originShieldRegion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.DistributionOriginOriginShield):
            DistributionOriginOriginShield = DistributionOriginOriginShield(
            enabled = javaType.enabled(),
            originShieldRegion = javaType.originShieldRegion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
