@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property contentTypeProfiles Object that contains an attribute `items` that contains the list of configurations for a field-level encryption content type-profile. See Content Type Profile.
 * @property forwardWhenContentTypeIsUnknown specifies what to do when an unknown content type is provided for the profile. If true, content is forwarded without being encrypted when the content type is unknown. If false (the default), an error is returned when the content type is unknown.
 */
public data class FieldLevelEncryptionConfigContentTypeProfileConfig(
    public val contentTypeProfiles:
    FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfiles,
    public val forwardWhenContentTypeIsUnknown: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.FieldLevelEncryptionConfigContentTypeProfileConfig):
            FieldLevelEncryptionConfigContentTypeProfileConfig =
            FieldLevelEncryptionConfigContentTypeProfileConfig(
                contentTypeProfiles = javaType.contentTypeProfiles().let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfiles.Companion.toKotlin(args0)
                }),
                forwardWhenContentTypeIsUnknown = javaType.forwardWhenContentTypeIsUnknown(),
            )
    }
}
