@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headerBehavior Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`.
 * @property headers Object that contains a list of header names. See Items for more information.
 */
public data class GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig(
    public val headerBehavior: String,
    public val headers:
    List<GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeader>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig):
            GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig =
            GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfig(
                headerBehavior = javaType.headerBehavior(),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeader.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
