@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property queryStringBehavior Determines whether any URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`, `allExcept`, `all`.
 * @property queryStrings Object that contains a list of query string names. See Items for more information.
 */
public data class GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig(
    public val queryStringBehavior: String,
    public val queryStrings:
    List<GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryString>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig):
            GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig =
            GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfig(
                queryStringBehavior = javaType.queryStringBehavior(),
                queryStrings = javaType.queryStrings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryString.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
