@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCachePolicy.
 * @property comment Comment to describe the cache policy.
 * @property defaultTtl Default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
 * @property etag Current version of the cache policy.
 * @property id
 * @property maxTtl Maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
 * @property minTtl Minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
 * @property name
 * @property parametersInCacheKeyAndForwardedToOrigins The HTTP headers, cookies, and URL query strings to include in the cache key. See Parameters In Cache Key And Forwarded To Origin for more information.
 */
public data class GetCachePolicyResult(
    public val comment: String,
    public val defaultTtl: Int,
    public val etag: String,
    public val id: String? = null,
    public val maxTtl: Int,
    public val minTtl: Int,
    public val name: String? = null,
    public val parametersInCacheKeyAndForwardedToOrigins:
    List<GetCachePolicyParametersInCacheKeyAndForwardedToOrigin>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetCachePolicyResult):
            GetCachePolicyResult = GetCachePolicyResult(
            comment = javaType.comment(),
            defaultTtl = javaType.defaultTtl(),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            maxTtl = javaType.maxTtl(),
            minTtl = javaType.minTtl(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parametersInCacheKeyAndForwardedToOrigins = javaType.parametersInCacheKeyAndForwardedToOrigins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOrigin.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
