@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property kinesisStreamConfigs (Required) Amazon Kinesis data stream configuration.
 * @property streamType (Required) Type of data stream where real-time log data is sent. The only valid value is `Kinesis`.
 */
public data class GetRealtimeLogConfigEndpoint(
    public val kinesisStreamConfigs: List<GetRealtimeLogConfigEndpointKinesisStreamConfig>,
    public val streamType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetRealtimeLogConfigEndpoint):
            GetRealtimeLogConfigEndpoint = GetRealtimeLogConfigEndpoint(
            kinesisStreamConfigs = javaType.kinesisStreamConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetRealtimeLogConfigEndpointKinesisStreamConfig.Companion.toKotlin(args0)
                })
            }),
            streamType = javaType.streamType(),
        )
    }
}
