@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRealtimeLogConfig.
 * @property arn ARN (Amazon Resource Name) of the CloudFront real-time log configuration.
 * @property endpoints (Required) Amazon Kinesis data streams where real-time log data is sent.
 * @property fields (Required) Fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property samplingRate (Required) Sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
 */
public data class GetRealtimeLogConfigResult(
    public val arn: String,
    public val endpoints: List<GetRealtimeLogConfigEndpoint>,
    public val fields: List<String>,
    public val id: String,
    public val name: String,
    public val samplingRate: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetRealtimeLogConfigResult):
            GetRealtimeLogConfigResult = GetRealtimeLogConfigResult(
            arn = javaType.arn(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetRealtimeLogConfigEndpoint.Companion.toKotlin(args0)
                })
            }),
            fields = javaType.fields().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            samplingRate = javaType.samplingRate(),
        )
    }
}
