@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResponseHeadersPolicy.
 * @property comment Comment to describe the response headers policy. The comment cannot be longer than 128 characters.
 * @property corsConfigs Configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
 * @property customHeadersConfigs Object that contains an attribute `items` that contains a list of Custom Headers. See Custom Header for more information.
 * @property etag Current version of the response headers policy.
 * @property id
 * @property name
 * @property removeHeadersConfigs Object that contains an attribute `items` that contains a list of Remove Headers. See Remove Header for more information.
 * @property securityHeadersConfigs A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
 * @property serverTimingHeadersConfigs (Optional) Configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
 */
public data class GetResponseHeadersPolicyResult(
    public val comment: String,
    public val corsConfigs: List<GetResponseHeadersPolicyCorsConfig>,
    public val customHeadersConfigs: List<GetResponseHeadersPolicyCustomHeadersConfig>,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val removeHeadersConfigs: List<GetResponseHeadersPolicyRemoveHeadersConfig>,
    public val securityHeadersConfigs: List<GetResponseHeadersPolicySecurityHeadersConfig>,
    public val serverTimingHeadersConfigs: List<GetResponseHeadersPolicyServerTimingHeadersConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.GetResponseHeadersPolicyResult):
            GetResponseHeadersPolicyResult = GetResponseHeadersPolicyResult(
            comment = javaType.comment(),
            corsConfigs = javaType.corsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyCorsConfig.Companion.toKotlin(args0)
                })
            }),
            customHeadersConfigs = javaType.customHeadersConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyCustomHeadersConfig.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            removeHeadersConfigs = javaType.removeHeadersConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyRemoveHeadersConfig.Companion.toKotlin(args0)
                })
            }),
            securityHeadersConfigs = javaType.securityHeadersConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicySecurityHeadersConfig.Companion.toKotlin(args0)
                })
            }),
            serverTimingHeadersConfigs = javaType.serverTimingHeadersConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyServerTimingHeadersConfig.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
