@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property roleArn The ARN of an IAM role that CloudFront can use to send real-time log data to the Kinesis data stream.
 * See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) for more information.
 * @property streamArn The ARN of the Kinesis data stream.
 */
public data class RealtimeLogConfigEndpointKinesisStreamConfig(
    public val roleArn: String,
    public val streamArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.RealtimeLogConfigEndpointKinesisStreamConfig):
            RealtimeLogConfigEndpointKinesisStreamConfig = RealtimeLogConfigEndpointKinesisStreamConfig(
            roleArn = javaType.roleArn(),
            streamArn = javaType.streamArn(),
        )
    }
}
