@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header. See Content Security Policy for more information.
 * @property contentTypeOptions Determines whether CloudFront includes the `X-Content-Type-Options` HTTP response header with its value set to `nosniff`. See Content Type Options for more information.
 * @property frameOptions Determines whether CloudFront includes the `X-Frame-Options` HTTP response header and the header’s value. See Frame Options for more information.
 * @property referrerPolicy Determines whether CloudFront includes the `Referrer-Policy` HTTP response header and the header’s value. See Referrer Policy for more information.
 * @property strictTransportSecurity Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header’s value. See Strict Transport Security for more information.
 * @property xssProtection Determine whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header’s value. See XSS Protection for more information.
 */
public data class ResponseHeadersPolicySecurityHeadersConfig(
    public val contentSecurityPolicy: ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy? =
        null,
    public val contentTypeOptions: ResponseHeadersPolicySecurityHeadersConfigContentTypeOptions? =
        null,
    public val frameOptions: ResponseHeadersPolicySecurityHeadersConfigFrameOptions? = null,
    public val referrerPolicy: ResponseHeadersPolicySecurityHeadersConfigReferrerPolicy? = null,
    public val strictTransportSecurity:
    ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity? = null,
    public val xssProtection: ResponseHeadersPolicySecurityHeadersConfigXssProtection? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicySecurityHeadersConfig):
            ResponseHeadersPolicySecurityHeadersConfig = ResponseHeadersPolicySecurityHeadersConfig(
            contentSecurityPolicy = javaType.contentSecurityPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentTypeOptions = javaType.contentTypeOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfigContentTypeOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frameOptions = javaType.frameOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfigFrameOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            referrerPolicy = javaType.referrerPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfigReferrerPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            strictTransportSecurity = javaType.strictTransportSecurity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            xssProtection = javaType.xssProtection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfigXssProtection.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
