@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header.
 * @property override Whether CloudFront overrides the `Content-Security-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy(
    public val contentSecurityPolicy: String,
    public val `override`: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy):
            ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy =
            ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicy(
                contentSecurityPolicy = javaType.contentSecurityPolicy(),
                `override` = javaType.`override`(),
            )
    }
}
