@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property override Whether CloudFront overrides the `Referrer-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
 * @property referrerPolicy The value of the `Referrer-Policy` HTTP response header. Valid Values: `no-referrer` | `no-referrer-when-downgrade` | `origin` | `origin-when-cross-origin` | `same-origin` | `strict-origin` | `strict-origin-when-cross-origin` | `unsafe-url`
 */
public data class ResponseHeadersPolicySecurityHeadersConfigReferrerPolicy(
    public val `override`: Boolean,
    public val referrerPolicy: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicySecurityHeadersConfigReferrerPolicy):
            ResponseHeadersPolicySecurityHeadersConfigReferrerPolicy =
            ResponseHeadersPolicySecurityHeadersConfigReferrerPolicy(
                `override` = javaType.`override`(),
                referrerPolicy = javaType.referrerPolicy(),
            )
    }
}
