@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin

import com.pulumi.aws.cloudhsmv2.HsmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates an HSM module in Amazon CloudHSM v2 cluster.
 * ## Example Usage
 * The following example below creates an HSM module in CloudHSM cluster.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudhsmv2.Cloudhsmv2Functions;
 * import com.pulumi.aws.cloudhsmv2.inputs.GetClusterArgs;
 * import com.pulumi.aws.cloudhsmv2.Hsm;
 * import com.pulumi.aws.cloudhsmv2.HsmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var cluster = Cloudhsmv2Functions.getCluster(GetClusterArgs.builder()
 *             .clusterId(var_.cloudhsm_cluster_id())
 *             .build());
 *         var cloudhsmV2Hsm = new Hsm("cloudhsmV2Hsm", HsmArgs.builder()
 *             .subnetId(cluster.applyValue(getClusterResult -> getClusterResult.subnetIds()[0]))
 *             .clusterId(cluster.applyValue(getClusterResult -> getClusterResult.clusterId()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import HSM modules using their HSM ID. For example:
 * ```sh
 *  $ pulumi import aws:cloudhsmv2/hsm:Hsm bar hsm-quo8dahtaca
 * ```
 * @property availabilityZone The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
 * @property clusterId The ID of Cloud HSM v2 cluster to which HSM will be added.
 * @property ipAddress The IP address of HSM module. Must be within the CIDR of selected subnet.
 * @property subnetId The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
 */
public data class HsmArgs(
    public val availabilityZone: Output<String>? = null,
    public val clusterId: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudhsmv2.HsmArgs> {
    override fun toJava(): com.pulumi.aws.cloudhsmv2.HsmArgs =
        com.pulumi.aws.cloudhsmv2.HsmArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HsmArgs].
 */
@PulumiTagMarker
public class HsmArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var clusterId: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
     */
    @JvmName("sxwvlehxyrjharrp")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The ID of Cloud HSM v2 cluster to which HSM will be added.
     */
    @JvmName("aloqjviuygmjhhpv")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The IP address of HSM module. Must be within the CIDR of selected subnet.
     */
    @JvmName("nwbrjcywvasonjpu")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
     */
    @JvmName("fwfpbqhtqxyspfmg")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
     */
    @JvmName("jskrhpvvhdtfarte")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The ID of Cloud HSM v2 cluster to which HSM will be added.
     */
    @JvmName("eorxhepqiscaifnr")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The IP address of HSM module. Must be within the CIDR of selected subnet.
     */
    @JvmName("pvxrfclebxguyapt")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
     */
    @JvmName("sdxvycyomhtqqanm")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): HsmArgs = HsmArgs(
        availabilityZone = availabilityZone,
        clusterId = clusterId,
        ipAddress = ipAddress,
        subnetId = subnetId,
    )
}
