@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudhsmv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCluster.
 * @property clusterCertificates The list of cluster certificates.
 * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
 * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in UNINITIALIZED state.
 * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
 * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
 * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
 * The number of available cluster certificates may vary depending on state of the cluster.
 * @property clusterId
 * @property clusterState
 * @property id The provider-assigned unique ID for this managed resource.
 * @property securityGroupId ID of the security group associated with the CloudHSM cluster.
 * @property subnetIds IDs of subnets in which cluster operates.
 * @property vpcId ID of the VPC that the CloudHSM cluster resides in.
 */
public data class GetClusterResult(
    public val clusterCertificates: List<GetClusterClusterCertificate>,
    public val clusterId: String,
    public val clusterState: String,
    public val id: String,
    public val securityGroupId: String,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudhsmv2.outputs.GetClusterResult):
            GetClusterResult = GetClusterResult(
            clusterCertificates = javaType.clusterCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudhsmv2.kotlin.outputs.GetClusterClusterCertificate.Companion.toKotlin(args0)
                })
            }),
            clusterId = javaType.clusterId(),
            clusterState = javaType.clusterState(),
            id = javaType.id(),
            securityGroupId = javaType.securityGroupId(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
