@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin

import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainEndpointOptions
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainIndexField
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainScalingParameters
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainEndpointOptions.Companion.toKotlin as domainEndpointOptionsToKotlin
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainIndexField.Companion.toKotlin as domainIndexFieldToKotlin
import com.pulumi.aws.cloudsearch.kotlin.outputs.DomainScalingParameters.Companion.toKotlin as domainScalingParametersToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.cloudsearch.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides an CloudSearch domain resource.
 * The provider waits for the domain to become `Active` when applying a configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudsearch.Domain;
 * import com.pulumi.aws.cloudsearch.DomainArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .indexFields(
 *                 DomainIndexFieldArgs.builder()
 *                     .analysisScheme("_en_default_")
 *                     .highlight(false)
 *                     .name("headline")
 *                     .return_(true)
 *                     .search(true)
 *                     .sort(true)
 *                     .type("text")
 *                     .build(),
 *                 DomainIndexFieldArgs.builder()
 *                     .facet(true)
 *                     .name("price")
 *                     .return_(true)
 *                     .search(true)
 *                     .sort(true)
 *                     .sourceFields("headline")
 *                     .type("double")
 *                     .build())
 *             .scalingParameters(DomainScalingParametersArgs.builder()
 *                 .desiredInstanceType("search.medium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudSearch Domains using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudsearch/domain:Domain example example-domain
 * ```
 *
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.cloudsearch.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The domain's ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The service endpoint for updating documents in a search domain.
     */
    public val documentServiceEndpoint: Output<String>
        get() = javaResource.documentServiceEndpoint().applyValue({ args0 -> args0 })

    /**
     * An internally generated unique identifier for the domain.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Domain endpoint options. Documented below.
     */
    public val endpointOptions: Output<DomainEndpointOptions>
        get() = javaResource.endpointOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                domainEndpointOptionsToKotlin(args0)
            })
        })

    /**
     * The index fields for documents added to the domain. Documented below.
     */
    public val indexFields: Output<List<DomainIndexField>>?
        get() = javaResource.indexFields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> domainIndexFieldToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
     */
    public val multiAz: Output<Boolean>
        get() = javaResource.multiAz().applyValue({ args0 -> args0 })

    /**
     * The name of the CloudSearch domain.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Domain scaling parameters. Documented below.
     */
    public val scalingParameters: Output<DomainScalingParameters>
        get() = javaResource.scalingParameters().applyValue({ args0 ->
            args0.let({ args0 ->
                domainScalingParametersToKotlin(args0)
            })
        })

    /**
     * The service endpoint for requesting search results from a search domain.
     */
    public val searchServiceEndpoint: Output<String>
        get() = javaResource.searchServiceEndpoint().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudsearch.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.cloudsearch.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
