@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin

import com.pulumi.aws.cloudsearch.DomainArgs.builder
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainEndpointOptionsArgs
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainEndpointOptionsArgsBuilder
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainIndexFieldArgs
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainIndexFieldArgsBuilder
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainScalingParametersArgs
import com.pulumi.aws.cloudsearch.kotlin.inputs.DomainScalingParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an CloudSearch domain resource.
 * The provider waits for the domain to become `Active` when applying a configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudsearch.Domain;
 * import com.pulumi.aws.cloudsearch.DomainArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainIndexFieldArgs;
 * import com.pulumi.aws.cloudsearch.inputs.DomainScalingParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .indexFields(
 *                 DomainIndexFieldArgs.builder()
 *                     .analysisScheme("_en_default_")
 *                     .highlight(false)
 *                     .name("headline")
 *                     .return_(true)
 *                     .search(true)
 *                     .sort(true)
 *                     .type("text")
 *                     .build(),
 *                 DomainIndexFieldArgs.builder()
 *                     .facet(true)
 *                     .name("price")
 *                     .return_(true)
 *                     .search(true)
 *                     .sort(true)
 *                     .sourceFields("headline")
 *                     .type("double")
 *                     .build())
 *             .scalingParameters(DomainScalingParametersArgs.builder()
 *                 .desiredInstanceType("search.medium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudSearch Domains using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudsearch/domain:Domain example example-domain
 * ```
 * @property endpointOptions Domain endpoint options. Documented below.
 * @property indexFields The index fields for documents added to the domain. Documented below.
 * @property multiAz Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
 * @property name The name of the CloudSearch domain.
 * @property scalingParameters Domain scaling parameters. Documented below.
 */
public data class DomainArgs(
    public val endpointOptions: Output<DomainEndpointOptionsArgs>? = null,
    public val indexFields: Output<List<DomainIndexFieldArgs>>? = null,
    public val multiAz: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val scalingParameters: Output<DomainScalingParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudsearch.DomainArgs> {
    override fun toJava(): com.pulumi.aws.cloudsearch.DomainArgs =
        com.pulumi.aws.cloudsearch.DomainArgs.builder()
            .endpointOptions(endpointOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .indexFields(
                indexFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .multiAz(multiAz?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scalingParameters(
                scalingParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var endpointOptions: Output<DomainEndpointOptionsArgs>? = null

    private var indexFields: Output<List<DomainIndexFieldArgs>>? = null

    private var multiAz: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var scalingParameters: Output<DomainScalingParametersArgs>? = null

    /**
     * @param value Domain endpoint options. Documented below.
     */
    @JvmName("dqcuenehqyldtkdh")
    public suspend fun endpointOptions(`value`: Output<DomainEndpointOptionsArgs>) {
        this.endpointOptions = value
    }

    /**
     * @param value The index fields for documents added to the domain. Documented below.
     */
    @JvmName("yeardkeubiiripab")
    public suspend fun indexFields(`value`: Output<List<DomainIndexFieldArgs>>) {
        this.indexFields = value
    }

    @JvmName("wewculdijwebglmv")
    public suspend fun indexFields(vararg values: Output<DomainIndexFieldArgs>) {
        this.indexFields = Output.all(values.asList())
    }

    /**
     * @param values The index fields for documents added to the domain. Documented below.
     */
    @JvmName("dexyvlxiooitmxhj")
    public suspend fun indexFields(values: List<Output<DomainIndexFieldArgs>>) {
        this.indexFields = Output.all(values)
    }

    /**
     * @param value Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
     */
    @JvmName("ulweoqvghxgwfbyv")
    public suspend fun multiAz(`value`: Output<Boolean>) {
        this.multiAz = value
    }

    /**
     * @param value The name of the CloudSearch domain.
     */
    @JvmName("iqoqvqsnxjxustda")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Domain scaling parameters. Documented below.
     */
    @JvmName("aswpvukurlfrihwn")
    public suspend fun scalingParameters(`value`: Output<DomainScalingParametersArgs>) {
        this.scalingParameters = value
    }

    /**
     * @param value Domain endpoint options. Documented below.
     */
    @JvmName("wpesluioswmumshn")
    public suspend fun endpointOptions(`value`: DomainEndpointOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointOptions = mapped
    }

    /**
     * @param argument Domain endpoint options. Documented below.
     */
    @JvmName("msxvkjlpgukhandj")
    public suspend
    fun endpointOptions(argument: suspend DomainEndpointOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainEndpointOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointOptions = mapped
    }

    /**
     * @param value The index fields for documents added to the domain. Documented below.
     */
    @JvmName("qwvsdsaqjbunggfd")
    public suspend fun indexFields(`value`: List<DomainIndexFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexFields = mapped
    }

    /**
     * @param argument The index fields for documents added to the domain. Documented below.
     */
    @JvmName("hksyjhwgqdisbpou")
    public suspend fun indexFields(argument: List<suspend DomainIndexFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainIndexFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.indexFields = mapped
    }

    /**
     * @param argument The index fields for documents added to the domain. Documented below.
     */
    @JvmName("ncrmcusumrofivdw")
    public suspend fun indexFields(vararg argument: suspend DomainIndexFieldArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainIndexFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.indexFields = mapped
    }

    /**
     * @param argument The index fields for documents added to the domain. Documented below.
     */
    @JvmName("whxnsastjwiaagps")
    public suspend fun indexFields(argument: suspend DomainIndexFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainIndexFieldArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.indexFields = mapped
    }

    /**
     * @param values The index fields for documents added to the domain. Documented below.
     */
    @JvmName("wrywaroceicdeted")
    public suspend fun indexFields(vararg values: DomainIndexFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexFields = mapped
    }

    /**
     * @param value Whether or not to maintain extra instances for the domain in a second Availability Zone to ensure high availability.
     */
    @JvmName("vbrvloitupnjhjsy")
    public suspend fun multiAz(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAz = mapped
    }

    /**
     * @param value The name of the CloudSearch domain.
     */
    @JvmName("ncivqlxfsrvetcrj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Domain scaling parameters. Documented below.
     */
    @JvmName("bxtdwpkfgloqkxxd")
    public suspend fun scalingParameters(`value`: DomainScalingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingParameters = mapped
    }

    /**
     * @param argument Domain scaling parameters. Documented below.
     */
    @JvmName("hxwmcprlboubwjyh")
    public suspend
    fun scalingParameters(argument: suspend DomainScalingParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DomainScalingParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scalingParameters = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        endpointOptions = endpointOptions,
        indexFields = indexFields,
        multiAz = multiAz,
        name = name,
        scalingParameters = scalingParameters,
    )
}
