@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin

import com.pulumi.aws.cloudsearch.DomainServiceAccessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an CloudSearch domain service access policy resource.
 * The provider waits for the domain service access policy to become `Active` when applying a configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudsearch.Domain;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudsearch.DomainServiceAccessPolicy;
 * import com.pulumi.aws.cloudsearch.DomainServiceAccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomain = new Domain("exampleDomain");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("search_only")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "cloudsearch:search",
 *                     "cloudsearch:document")
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("192.0.2.0/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleDomainServiceAccessPolicy = new DomainServiceAccessPolicy("exampleDomainServiceAccessPolicy", DomainServiceAccessPolicyArgs.builder()
 *             .domainName(exampleDomain.id())
 *             .accessPolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudSearch domain service access policies using the domain name. For example:
 * ```sh
 *  $ pulumi import aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy example example-domain
 * ```
 * @property accessPolicy The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
 * @property domainName The CloudSearch domain name the policy applies to.
 */
public data class DomainServiceAccessPolicyArgs(
    public val accessPolicy: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudsearch.DomainServiceAccessPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudsearch.DomainServiceAccessPolicyArgs =
        com.pulumi.aws.cloudsearch.DomainServiceAccessPolicyArgs.builder()
            .accessPolicy(accessPolicy?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainServiceAccessPolicyArgs].
 */
@PulumiTagMarker
public class DomainServiceAccessPolicyArgsBuilder internal constructor() {
    private var accessPolicy: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
     */
    @JvmName("shvjcntbjknnymxl")
    public suspend fun accessPolicy(`value`: Output<String>) {
        this.accessPolicy = value
    }

    /**
     * @param value The CloudSearch domain name the policy applies to.
     */
    @JvmName("krrwbruqtiuucnsj")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
     */
    @JvmName("oyjgnnluosjgikuy")
    public suspend fun accessPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicy = mapped
    }

    /**
     * @param value The CloudSearch domain name the policy applies to.
     */
    @JvmName("chmpqxjwihvkrbfe")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainServiceAccessPolicyArgs = DomainServiceAccessPolicyArgs(
        accessPolicy = accessPolicy,
        domainName = domainName,
    )
}
