@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property analysisScheme The analysis scheme you want to use for a `text` field. The analysis scheme specifies the language-specific text processing options that are used during indexing.
 * @property defaultValue The default value for the field. This value is used when no value is specified for the field in the document data.
 * @property facet You can get facet information by enabling this.
 * @property highlight You can highlight information.
 * @property name A unique name for the field. Field names must begin with a letter and be at least 3 and no more than 64 characters long. The allowed characters are: `a`-`z` (lower-case letters), `0`-`9`, and `_` (underscore). The name `score` is reserved and cannot be used as a field name.
 * @property return You can enable returning the value of all searchable fields.
 * @property search You can set whether this index should be searchable or not.
 * @property sort You can enable the property to be sortable.
 * @property sourceFields A comma-separated list of source fields to map to the field. Specifying a source field copies data from one field to another, enabling you to use the same source data in different ways by configuring different options for the fields.
 * @property type The field type. Valid values: `date`, `date-array`, `double`, `double-array`, `int`, `int-array`, `literal`, `literal-array`, `text`, `text-array`.
 */
public data class DomainIndexField(
    public val analysisScheme: String? = null,
    public val defaultValue: String? = null,
    public val facet: Boolean? = null,
    public val highlight: Boolean? = null,
    public val name: String,
    public val `return`: Boolean? = null,
    public val search: Boolean? = null,
    public val sort: Boolean? = null,
    public val sourceFields: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudsearch.outputs.DomainIndexField):
            DomainIndexField = DomainIndexField(
            analysisScheme = javaType.analysisScheme().map({ args0 -> args0 }).orElse(null),
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            facet = javaType.facet().map({ args0 -> args0 }).orElse(null),
            highlight = javaType.highlight().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `return` = javaType.return_().map({ args0 -> args0 }).orElse(null),
            search = javaType.search().map({ args0 -> args0 }).orElse(null),
            sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
            sourceFields = javaType.sourceFields().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
