@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin

import com.pulumi.aws.cloudtrail.CloudtrailFunctions.getServiceAccountPlain
import com.pulumi.aws.cloudtrail.kotlin.inputs.GetServiceAccountPlainArgs
import com.pulumi.aws.cloudtrail.kotlin.inputs.GetServiceAccountPlainArgsBuilder
import com.pulumi.aws.cloudtrail.kotlin.outputs.GetServiceAccountResult
import com.pulumi.aws.cloudtrail.kotlin.outputs.GetServiceAccountResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object CloudtrailFunctions {
    /**
     * Use this data source to get the Account ID of the [AWS CloudTrail Service Account](http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-supported-regions.html)
     * in a given region for the purpose of allowing CloudTrail to store trail data in S3.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudtrail.CloudtrailFunctions;
     * import com.pulumi.aws.cloudtrail.inputs.GetServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = CloudtrailFunctions.getServiceAccount();
     *         var bucket = new BucketV2("bucket", BucketV2Args.builder()
     *             .forceDestroy(true)
     *             .build());
     *         final var allowCloudtrailLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("Put bucket policy needed for trails")
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getServiceAccountResult -> getServiceAccountResult.arn()))
     *                         .build())
     *                     .actions("s3:PutObject")
     *                     .resources(bucket.arn().applyValue(arn -> String.format("%s/*", arn)))
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("Get bucket policy needed for trails")
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getServiceAccountResult -> getServiceAccountResult.arn()))
     *                         .build())
     *                     .actions("s3:GetBucketAcl")
     *                     .resources(bucket.arn())
     *                     .build())
     *             .build());
     *         var allowCloudtrailLoggingBucketPolicy = new BucketPolicy("allowCloudtrailLoggingBucketPolicy", BucketPolicyArgs.builder()
     *             .bucket(bucket.id())
     *             .policy(allowCloudtrailLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(allowCloudtrailLoggingPolicyDocument -> allowCloudtrailLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getServiceAccount.
     * @return A collection of values returned by getServiceAccount.
     * */
     */
    public suspend fun getServiceAccount(argument: GetServiceAccountPlainArgs):
        GetServiceAccountResult = toKotlin(getServiceAccountPlain(argument.toJava()).await())

    /**
     * @see [getServiceAccount].
     * @param region Name of the region whose AWS CloudTrail account ID is desired.
     * Defaults to the region from the AWS provider configuration.
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend fun getServiceAccount(region: String? = null): GetServiceAccountResult {
        val argument = GetServiceAccountPlainArgs(
            region = region,
        )
        return toKotlin(getServiceAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceAccount].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudtrail&#46;kotlin&#46;inputs&#46;GetServiceAccountPlainArgs].
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend
    fun getServiceAccount(argument: suspend GetServiceAccountPlainArgsBuilder.() -> Unit):
        GetServiceAccountResult {
        val builder = GetServiceAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getServiceAccountPlain(builtArgument.toJava()).await())
    }
}
