@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin

import com.pulumi.aws.cloudtrail.kotlin.outputs.TrailAdvancedEventSelector
import com.pulumi.aws.cloudtrail.kotlin.outputs.TrailEventSelector
import com.pulumi.aws.cloudtrail.kotlin.outputs.TrailInsightSelector
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudtrail.kotlin.outputs.TrailAdvancedEventSelector.Companion.toKotlin as trailAdvancedEventSelectorToKotlin
import com.pulumi.aws.cloudtrail.kotlin.outputs.TrailEventSelector.Companion.toKotlin as trailEventSelectorToKotlin
import com.pulumi.aws.cloudtrail.kotlin.outputs.TrailInsightSelector.Companion.toKotlin as trailInsightSelectorToKotlin

/**
 * Builder for [Trail].
 */
@PulumiTagMarker
public class TrailResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrailArgs = TrailArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrailArgsBuilder.() -> Unit) {
        val builder = TrailArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Trail {
        val builtJavaResource = com.pulumi.aws.cloudtrail.Trail(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Trail(builtJavaResource)
    }
}

/**
 * Provides a CloudTrail resource.
 * > **Tip:** For a multi-region trail, this resource must be in the home region of the trail.
 * > **Tip:** For an organization trail, this resource must be in the master account of the organization.
 * ## Example Usage
 * ### Basic
 * Enable CloudTrail to capture all compatible management events in region.
 * For capturing events from services like IAM, `include_global_service_events` must be enabled.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("AWSCloudTrailAclCheck")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("cloudtrail.amazonaws.com")
 *                         .build())
 *                     .actions("s3:GetBucketAcl")
 *                     .resources(exampleBucketV2.arn())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("aws:SourceArn")
 *                         .values(String.format("arn:%s:cloudtrail:%s:%s:trail/example", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("AWSCloudTrailWrite")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("cloudtrail.amazonaws.com")
 *                         .build())
 *                     .actions("s3:PutObject")
 *                     .resources(exampleBucketV2.arn().applyValue(arn -> String.format("%s/prefix/AWSLogs/%s/*", arn,currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *                     .conditions(
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("s3:x-amz-acl")
 *                             .values("bucket-owner-full-control")
 *                             .build(),
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("aws:SourceArn")
 *                             .values(String.format("arn:%s:cloudtrail:%s:%s:trail/example", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                             .build())
 *                     .build())
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleTrail = new Trail("exampleTrail", TrailArgs.builder()
 *             .s3BucketName(exampleBucketV2.id())
 *             .s3KeyPrefix("prefix")
 *             .includeGlobalServiceEvents(false)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ### Logging All Lambda Function Invocations By Using Basic Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trail("example", TrailArgs.builder()
 *             .eventSelectors(TrailEventSelectorArgs.builder()
 *                 .dataResources(TrailEventSelectorDataResourceArgs.builder()
 *                     .type("AWS::Lambda::Function")
 *                     .values("arn:aws:lambda")
 *                     .build())
 *                 .includeManagementEvents(true)
 *                 .readWriteType("All")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging All S3 Object Events By Using Basic Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trail("example", TrailArgs.builder()
 *             .eventSelectors(TrailEventSelectorArgs.builder()
 *                 .dataResources(TrailEventSelectorDataResourceArgs.builder()
 *                     .type("AWS::S3::Object")
 *                     .values("arn:aws:s3")
 *                     .build())
 *                 .includeManagementEvents(true)
 *                 .readWriteType("All")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging Individual S3 Bucket Events By Using Basic Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var important-bucket = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket")
 *             .build());
 *         var example = new Trail("example", TrailArgs.builder()
 *             .eventSelectors(TrailEventSelectorArgs.builder()
 *                 .dataResources(TrailEventSelectorDataResourceArgs.builder()
 *                     .type("AWS::S3::Object")
 *                     .values(String.format("%s/", important_bucket.arn()))
 *                     .build())
 *                 .includeManagementEvents(true)
 *                 .readWriteType("All")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging All S3 Object Events Except For Two S3 Buckets By Using Advanced Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var not-important-bucket-1 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("not-important-bucket-1")
 *             .build());
 *         final var not-important-bucket-2 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("not-important-bucket-2")
 *             .build());
 *         var example = new Trail("example", TrailArgs.builder()
 *             .advancedEventSelectors(
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("Data")
 *                             .field("eventCategory")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .field("resources.ARN")
 *                             .notStartsWith(
 *                                 String.format("%s/", not_important_bucket_1.arn()),
 *                                 String.format("%s/", not_important_bucket_2.arn()))
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("AWS::S3::Object")
 *                             .field("resources.type")
 *                             .build())
 *                     .name("Log all S3 objects events except for two S3 buckets")
 *                     .build(),
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                         .equals("Management")
 *                         .field("eventCategory")
 *                         .build())
 *                     .name("Log readOnly and writeOnly management events")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging Individual S3 Buckets And Specific Event Names By Using Advanced Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var important-bucket-1 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket-1")
 *             .build());
 *         final var important-bucket-2 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket-2")
 *             .build());
 *         final var important-bucket-3 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket-3")
 *             .build());
 *         var example = new Trail("example", TrailArgs.builder()
 *             .advancedEventSelectors(
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("Data")
 *                             .field("eventCategory")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals(
 *                                 "PutObject",
 *                                 "DeleteObject")
 *                             .field("eventName")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .field("resources.ARN")
 *                             .startsWith(
 *                                 String.format("%s/", important_bucket_1.arn()),
 *                                 String.format("%s/", important_bucket_2.arn()))
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("false")
 *                             .field("readOnly")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("AWS::S3::Object")
 *                             .field("resources.type")
 *                             .build())
 *                     .name("Log PutObject and DeleteObject events for two S3 buckets")
 *                     .build(),
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("Data")
 *                             .field("eventCategory")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .field("eventName")
 *                             .startsWith("Delete")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals(String.format("%s/important-prefix", important_bucket_3.arn()))
 *                             .field("resources.ARN")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("false")
 *                             .field("readOnly")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("AWS::S3::Object")
 *                             .field("resources.type")
 *                             .build())
 *                     .name("Log Delete* events for one S3 bucket")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Sending Events to CloudWatch Logs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleTrail = new Trail("exampleTrail", TrailArgs.builder()
 *             .cloudWatchLogsGroupArn(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudtrails using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:cloudtrail/trail:Trail sample arn:aws:cloudtrail:us-east-1:123456789012:trail/my-sample-trail
 * ```
 * */
 */
public class Trail internal constructor(
    override val javaResource: com.pulumi.aws.cloudtrail.Trail,
) : KotlinCustomResource(javaResource, TrailMapper) {
    /**
     * Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    public val advancedEventSelectors: Output<List<TrailAdvancedEventSelector>>?
        get() = javaResource.advancedEventSelectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        trailAdvancedEventSelectorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * ARN of the trail.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Log group name using an ARN that represents the log group to which CloudTrail logs will be delivered. Note that CloudTrail requires the Log Stream wildcard.
     */
    public val cloudWatchLogsGroupArn: Output<String>?
        get() = javaResource.cloudWatchLogsGroupArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Role for the CloudWatch Logs endpoint to assume to write to a user’s log group.
     */
    public val cloudWatchLogsRoleArn: Output<String>?
        get() = javaResource.cloudWatchLogsRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether log file integrity validation is enabled. Defaults to `false`.
     */
    public val enableLogFileValidation: Output<Boolean>?
        get() = javaResource.enableLogFileValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables logging for the trail. Defaults to `true`. Setting this to `false` will pause logging.
     */
    public val enableLogging: Output<Boolean>?
        get() = javaResource.enableLogging().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    public val eventSelectors: Output<List<TrailEventSelector>>?
        get() = javaResource.eventSelectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        trailEventSelectorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Region in which the trail was created.
     */
    public val homeRegion: Output<String>
        get() = javaResource.homeRegion().applyValue({ args0 -> args0 })

    /**
     * Whether the trail is publishing events from global services such as IAM to the log files. Defaults to `true`.
     */
    public val includeGlobalServiceEvents: Output<Boolean>?
        get() = javaResource.includeGlobalServiceEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for identifying unusual operational activity. See details below.
     */
    public val insightSelectors: Output<List<TrailInsightSelector>>?
        get() = javaResource.insightSelectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        trailInsightSelectorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Whether the trail is created in the current region or in all regions. Defaults to `false`.
     */
    public val isMultiRegionTrail: Output<Boolean>?
        get() = javaResource.isMultiRegionTrail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the trail is an AWS Organizations trail. Organization trails log events for the master account and all member accounts. Can only be created in the organization master account. Defaults to `false`.
     */
    public val isOrganizationTrail: Output<Boolean>?
        get() = javaResource.isOrganizationTrail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * KMS key ARN to use to encrypt the logs delivered by CloudTrail.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the trail.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name of the S3 bucket designated for publishing log files.
     * The following arguments are optional:
     */
    public val s3BucketName: Output<String>
        get() = javaResource.s3BucketName().applyValue({ args0 -> args0 })

    /**
     * S3 key prefix that follows the name of the bucket you have designated for log file delivery.
     */
    public val s3KeyPrefix: Output<String>?
        get() = javaResource.s3KeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the Amazon SNS topic defined for notification of log file delivery.
     */
    public val snsTopicName: Output<String>?
        get() = javaResource.snsTopicName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the trail. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TrailMapper : ResourceMapper<Trail> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudtrail.Trail::class == javaResource::class

    override fun map(javaResource: Resource): Trail = Trail(
        javaResource as
            com.pulumi.aws.cloudtrail.Trail,
    )
}

/**
 * @see [Trail].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Trail].
 */
public suspend fun trail(name: String, block: suspend TrailResourceBuilder.() -> Unit): Trail {
    val builder = TrailResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Trail].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trail(name: String): Trail {
    val builder = TrailResourceBuilder()
    builder.name(name)
    return builder.build()
}
