@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin

import com.pulumi.aws.cloudtrail.TrailArgs.builder
import com.pulumi.aws.cloudtrail.kotlin.inputs.TrailAdvancedEventSelectorArgs
import com.pulumi.aws.cloudtrail.kotlin.inputs.TrailAdvancedEventSelectorArgsBuilder
import com.pulumi.aws.cloudtrail.kotlin.inputs.TrailEventSelectorArgs
import com.pulumi.aws.cloudtrail.kotlin.inputs.TrailEventSelectorArgsBuilder
import com.pulumi.aws.cloudtrail.kotlin.inputs.TrailInsightSelectorArgs
import com.pulumi.aws.cloudtrail.kotlin.inputs.TrailInsightSelectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudTrail resource.
 * > **Tip:** For a multi-region trail, this resource must be in the home region of the trail.
 * > **Tip:** For an organization trail, this resource must be in the master account of the organization.
 * ## Example Usage
 * ### Basic
 * Enable CloudTrail to capture all compatible management events in region.
 * For capturing events from services like IAM, `include_global_service_events` must be enabled.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("AWSCloudTrailAclCheck")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("cloudtrail.amazonaws.com")
 *                         .build())
 *                     .actions("s3:GetBucketAcl")
 *                     .resources(exampleBucketV2.arn())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("aws:SourceArn")
 *                         .values(String.format("arn:%s:cloudtrail:%s:%s:trail/example", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("AWSCloudTrailWrite")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("cloudtrail.amazonaws.com")
 *                         .build())
 *                     .actions("s3:PutObject")
 *                     .resources(exampleBucketV2.arn().applyValue(arn -> String.format("%s/prefix/AWSLogs/%s/*", arn,currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *                     .conditions(
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("s3:x-amz-acl")
 *                             .values("bucket-owner-full-control")
 *                             .build(),
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("aws:SourceArn")
 *                             .values(String.format("arn:%s:cloudtrail:%s:%s:trail/example", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                             .build())
 *                     .build())
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleTrail = new Trail("exampleTrail", TrailArgs.builder()
 *             .s3BucketName(exampleBucketV2.id())
 *             .s3KeyPrefix("prefix")
 *             .includeGlobalServiceEvents(false)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ### Logging All Lambda Function Invocations By Using Basic Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trail("example", TrailArgs.builder()
 *             .eventSelectors(TrailEventSelectorArgs.builder()
 *                 .dataResources(TrailEventSelectorDataResourceArgs.builder()
 *                     .type("AWS::Lambda::Function")
 *                     .values("arn:aws:lambda")
 *                     .build())
 *                 .includeManagementEvents(true)
 *                 .readWriteType("All")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging All S3 Object Events By Using Basic Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trail("example", TrailArgs.builder()
 *             .eventSelectors(TrailEventSelectorArgs.builder()
 *                 .dataResources(TrailEventSelectorDataResourceArgs.builder()
 *                     .type("AWS::S3::Object")
 *                     .values("arn:aws:s3")
 *                     .build())
 *                 .includeManagementEvents(true)
 *                 .readWriteType("All")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging Individual S3 Bucket Events By Using Basic Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var important-bucket = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket")
 *             .build());
 *         var example = new Trail("example", TrailArgs.builder()
 *             .eventSelectors(TrailEventSelectorArgs.builder()
 *                 .dataResources(TrailEventSelectorDataResourceArgs.builder()
 *                     .type("AWS::S3::Object")
 *                     .values(String.format("%s/", important_bucket.arn()))
 *                     .build())
 *                 .includeManagementEvents(true)
 *                 .readWriteType("All")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging All S3 Object Events Except For Two S3 Buckets By Using Advanced Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var not-important-bucket-1 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("not-important-bucket-1")
 *             .build());
 *         final var not-important-bucket-2 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("not-important-bucket-2")
 *             .build());
 *         var example = new Trail("example", TrailArgs.builder()
 *             .advancedEventSelectors(
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("Data")
 *                             .field("eventCategory")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .field("resources.ARN")
 *                             .notStartsWith(
 *                                 String.format("%s/", not_important_bucket_1.arn()),
 *                                 String.format("%s/", not_important_bucket_2.arn()))
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("AWS::S3::Object")
 *                             .field("resources.type")
 *                             .build())
 *                     .name("Log all S3 objects events except for two S3 buckets")
 *                     .build(),
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                         .equals("Management")
 *                         .field("eventCategory")
 *                         .build())
 *                     .name("Log readOnly and writeOnly management events")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging Individual S3 Buckets And Specific Event Names By Using Advanced Event Selectors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import com.pulumi.aws.cloudtrail.inputs.TrailAdvancedEventSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var important-bucket-1 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket-1")
 *             .build());
 *         final var important-bucket-2 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket-2")
 *             .build());
 *         final var important-bucket-3 = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("important-bucket-3")
 *             .build());
 *         var example = new Trail("example", TrailArgs.builder()
 *             .advancedEventSelectors(
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("Data")
 *                             .field("eventCategory")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals(
 *                                 "PutObject",
 *                                 "DeleteObject")
 *                             .field("eventName")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .field("resources.ARN")
 *                             .startsWith(
 *                                 String.format("%s/", important_bucket_1.arn()),
 *                                 String.format("%s/", important_bucket_2.arn()))
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("false")
 *                             .field("readOnly")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("AWS::S3::Object")
 *                             .field("resources.type")
 *                             .build())
 *                     .name("Log PutObject and DeleteObject events for two S3 buckets")
 *                     .build(),
 *                 TrailAdvancedEventSelectorArgs.builder()
 *                     .fieldSelectors(
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("Data")
 *                             .field("eventCategory")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .field("eventName")
 *                             .startsWith("Delete")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals(String.format("%s/important-prefix", important_bucket_3.arn()))
 *                             .field("resources.ARN")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("false")
 *                             .field("readOnly")
 *                             .build(),
 *                         TrailAdvancedEventSelectorFieldSelectorArgs.builder()
 *                             .equals("AWS::S3::Object")
 *                             .field("resources.type")
 *                             .build())
 *                     .name("Log Delete* events for one S3 bucket")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Sending Events to CloudWatch Logs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudtrail.Trail;
 * import com.pulumi.aws.cloudtrail.TrailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleTrail = new Trail("exampleTrail", TrailArgs.builder()
 *             .cloudWatchLogsGroupArn(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudtrails using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:cloudtrail/trail:Trail sample arn:aws:cloudtrail:us-east-1:123456789012:trail/my-sample-trail
 * ```
 * @property advancedEventSelectors Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
 * @property cloudWatchLogsGroupArn Log group name using an ARN that represents the log group to which CloudTrail logs will be delivered. Note that CloudTrail requires the Log Stream wildcard.
 * @property cloudWatchLogsRoleArn Role for the CloudWatch Logs endpoint to assume to write to a user’s log group.
 * @property enableLogFileValidation Whether log file integrity validation is enabled. Defaults to `false`.
 * @property enableLogging Enables logging for the trail. Defaults to `true`. Setting this to `false` will pause logging.
 * @property eventSelectors Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
 * @property includeGlobalServiceEvents Whether the trail is publishing events from global services such as IAM to the log files. Defaults to `true`.
 * @property insightSelectors Configuration block for identifying unusual operational activity. See details below.
 * @property isMultiRegionTrail Whether the trail is created in the current region or in all regions. Defaults to `false`.
 * @property isOrganizationTrail Whether the trail is an AWS Organizations trail. Organization trails log events for the master account and all member accounts. Can only be created in the organization master account. Defaults to `false`.
 * @property kmsKeyId KMS key ARN to use to encrypt the logs delivered by CloudTrail.
 * @property name Name of the trail.
 * @property s3BucketName Name of the S3 bucket designated for publishing log files.
 * The following arguments are optional:
 * @property s3KeyPrefix S3 key prefix that follows the name of the bucket you have designated for log file delivery.
 * @property snsTopicName Name of the Amazon SNS topic defined for notification of log file delivery.
 * @property tags Map of tags to assign to the trail. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */
 */
public data class TrailArgs(
    public val advancedEventSelectors: Output<List<TrailAdvancedEventSelectorArgs>>? = null,
    public val cloudWatchLogsGroupArn: Output<String>? = null,
    public val cloudWatchLogsRoleArn: Output<String>? = null,
    public val enableLogFileValidation: Output<Boolean>? = null,
    public val enableLogging: Output<Boolean>? = null,
    public val eventSelectors: Output<List<TrailEventSelectorArgs>>? = null,
    public val includeGlobalServiceEvents: Output<Boolean>? = null,
    public val insightSelectors: Output<List<TrailInsightSelectorArgs>>? = null,
    public val isMultiRegionTrail: Output<Boolean>? = null,
    public val isOrganizationTrail: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val s3BucketName: Output<String>? = null,
    public val s3KeyPrefix: Output<String>? = null,
    public val snsTopicName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudtrail.TrailArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.TrailArgs =
        com.pulumi.aws.cloudtrail.TrailArgs.builder()
            .advancedEventSelectors(
                advancedEventSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cloudWatchLogsGroupArn(cloudWatchLogsGroupArn?.applyValue({ args0 -> args0 }))
            .cloudWatchLogsRoleArn(cloudWatchLogsRoleArn?.applyValue({ args0 -> args0 }))
            .enableLogFileValidation(enableLogFileValidation?.applyValue({ args0 -> args0 }))
            .enableLogging(enableLogging?.applyValue({ args0 -> args0 }))
            .eventSelectors(
                eventSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .includeGlobalServiceEvents(includeGlobalServiceEvents?.applyValue({ args0 -> args0 }))
            .insightSelectors(
                insightSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isMultiRegionTrail(isMultiRegionTrail?.applyValue({ args0 -> args0 }))
            .isOrganizationTrail(isOrganizationTrail?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .s3BucketName(s3BucketName?.applyValue({ args0 -> args0 }))
            .s3KeyPrefix(s3KeyPrefix?.applyValue({ args0 -> args0 }))
            .snsTopicName(snsTopicName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TrailArgs].
 */
@PulumiTagMarker
public class TrailArgsBuilder internal constructor() {
    private var advancedEventSelectors: Output<List<TrailAdvancedEventSelectorArgs>>? = null

    private var cloudWatchLogsGroupArn: Output<String>? = null

    private var cloudWatchLogsRoleArn: Output<String>? = null

    private var enableLogFileValidation: Output<Boolean>? = null

    private var enableLogging: Output<Boolean>? = null

    private var eventSelectors: Output<List<TrailEventSelectorArgs>>? = null

    private var includeGlobalServiceEvents: Output<Boolean>? = null

    private var insightSelectors: Output<List<TrailInsightSelectorArgs>>? = null

    private var isMultiRegionTrail: Output<Boolean>? = null

    private var isOrganizationTrail: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var s3BucketName: Output<String>? = null

    private var s3KeyPrefix: Output<String>? = null

    private var snsTopicName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    @JvmName("ybeeudnfcjwfiifi")
    public suspend fun advancedEventSelectors(`value`: Output<List<TrailAdvancedEventSelectorArgs>>) {
        this.advancedEventSelectors = value
    }

    @JvmName("efipnbvddhxojcea")
    public suspend fun advancedEventSelectors(vararg values: Output<TrailAdvancedEventSelectorArgs>) {
        this.advancedEventSelectors = Output.all(values.asList())
    }

    /**
     * @param values Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    @JvmName("iyqtelbsqfaachhm")
    public suspend fun advancedEventSelectors(values: List<Output<TrailAdvancedEventSelectorArgs>>) {
        this.advancedEventSelectors = Output.all(values)
    }

    /**
     * @param value Log group name using an ARN that represents the log group to which CloudTrail logs will be delivered. Note that CloudTrail requires the Log Stream wildcard.
     */
    @JvmName("ckhyhtadtexqumlk")
    public suspend fun cloudWatchLogsGroupArn(`value`: Output<String>) {
        this.cloudWatchLogsGroupArn = value
    }

    /**
     * @param value Role for the CloudWatch Logs endpoint to assume to write to a user’s log group.
     */
    @JvmName("fsjhbujfsmkfykcp")
    public suspend fun cloudWatchLogsRoleArn(`value`: Output<String>) {
        this.cloudWatchLogsRoleArn = value
    }

    /**
     * @param value Whether log file integrity validation is enabled. Defaults to `false`.
     */
    @JvmName("gpvvkjgvgxjfhfrh")
    public suspend fun enableLogFileValidation(`value`: Output<Boolean>) {
        this.enableLogFileValidation = value
    }

    /**
     * @param value Enables logging for the trail. Defaults to `true`. Setting this to `false` will pause logging.
     */
    @JvmName("kmfrddryfetvwlht")
    public suspend fun enableLogging(`value`: Output<Boolean>) {
        this.enableLogging = value
    }

    /**
     * @param value Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    @JvmName("caxqnboitfpohgkp")
    public suspend fun eventSelectors(`value`: Output<List<TrailEventSelectorArgs>>) {
        this.eventSelectors = value
    }

    @JvmName("xgryitcipapfrono")
    public suspend fun eventSelectors(vararg values: Output<TrailEventSelectorArgs>) {
        this.eventSelectors = Output.all(values.asList())
    }

    /**
     * @param values Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    @JvmName("tpqjbrnfkcmdiaec")
    public suspend fun eventSelectors(values: List<Output<TrailEventSelectorArgs>>) {
        this.eventSelectors = Output.all(values)
    }

    /**
     * @param value Whether the trail is publishing events from global services such as IAM to the log files. Defaults to `true`.
     */
    @JvmName("esqdnvreqmgnkseb")
    public suspend fun includeGlobalServiceEvents(`value`: Output<Boolean>) {
        this.includeGlobalServiceEvents = value
    }

    /**
     * @param value Configuration block for identifying unusual operational activity. See details below.
     */
    @JvmName("oguunuwfxgpwhbei")
    public suspend fun insightSelectors(`value`: Output<List<TrailInsightSelectorArgs>>) {
        this.insightSelectors = value
    }

    @JvmName("ufnmywkeuabpbrqr")
    public suspend fun insightSelectors(vararg values: Output<TrailInsightSelectorArgs>) {
        this.insightSelectors = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for identifying unusual operational activity. See details below.
     */
    @JvmName("ahglknjpcgarvayw")
    public suspend fun insightSelectors(values: List<Output<TrailInsightSelectorArgs>>) {
        this.insightSelectors = Output.all(values)
    }

    /**
     * @param value Whether the trail is created in the current region or in all regions. Defaults to `false`.
     */
    @JvmName("xgavryebcblabeoh")
    public suspend fun isMultiRegionTrail(`value`: Output<Boolean>) {
        this.isMultiRegionTrail = value
    }

    /**
     * @param value Whether the trail is an AWS Organizations trail. Organization trails log events for the master account and all member accounts. Can only be created in the organization master account. Defaults to `false`.
     */
    @JvmName("fdtkyffrypxgyhwc")
    public suspend fun isOrganizationTrail(`value`: Output<Boolean>) {
        this.isOrganizationTrail = value
    }

    /**
     * @param value KMS key ARN to use to encrypt the logs delivered by CloudTrail.
     */
    @JvmName("kwuxrdkhmxwqbter")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the trail.
     */
    @JvmName("bgpglgpwpkwtfkcb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the S3 bucket designated for publishing log files.
     * The following arguments are optional:
     */
    @JvmName("acaeurjumexejhjh")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value S3 key prefix that follows the name of the bucket you have designated for log file delivery.
     */
    @JvmName("cxcvasdjbqywnpkr")
    public suspend fun s3KeyPrefix(`value`: Output<String>) {
        this.s3KeyPrefix = value
    }

    /**
     * @param value Name of the Amazon SNS topic defined for notification of log file delivery.
     */
    @JvmName("nyaqelwhpxwwjfgr")
    public suspend fun snsTopicName(`value`: Output<String>) {
        this.snsTopicName = value
    }

    /**
     * @param value Map of tags to assign to the trail. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sfsgyxvydbsrlnbk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    @JvmName("xcmiwjhsftirmbhv")
    public suspend fun advancedEventSelectors(`value`: List<TrailAdvancedEventSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedEventSelectors = mapped
    }

    /**
     * @param argument Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    @JvmName("odmtifwsxmyldkrh")
    public suspend
    fun advancedEventSelectors(argument: List<suspend TrailAdvancedEventSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrailAdvancedEventSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedEventSelectors = mapped
    }

    /**
     * @param argument Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    @JvmName("bhqwydllesyaopah")
    public suspend fun advancedEventSelectors(
        vararg
        argument: suspend TrailAdvancedEventSelectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrailAdvancedEventSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedEventSelectors = mapped
    }

    /**
     * @param argument Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    @JvmName("waphwwdwawbvweyp")
    public suspend
    fun advancedEventSelectors(argument: suspend TrailAdvancedEventSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TrailAdvancedEventSelectorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.advancedEventSelectors = mapped
    }

    /**
     * @param values Specifies an advanced event selector for enabling data event logging. Fields documented below. Conflicts with `event_selector`.
     */
    @JvmName("mampisffsfuqxhon")
    public suspend fun advancedEventSelectors(vararg values: TrailAdvancedEventSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedEventSelectors = mapped
    }

    /**
     * @param value Log group name using an ARN that represents the log group to which CloudTrail logs will be delivered. Note that CloudTrail requires the Log Stream wildcard.
     */
    @JvmName("jnpgqrvymxyivrig")
    public suspend fun cloudWatchLogsGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchLogsGroupArn = mapped
    }

    /**
     * @param value Role for the CloudWatch Logs endpoint to assume to write to a user’s log group.
     */
    @JvmName("gqbvyexqmsbnkfoj")
    public suspend fun cloudWatchLogsRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchLogsRoleArn = mapped
    }

    /**
     * @param value Whether log file integrity validation is enabled. Defaults to `false`.
     */
    @JvmName("mqywiqpjidfifvrn")
    public suspend fun enableLogFileValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableLogFileValidation = mapped
    }

    /**
     * @param value Enables logging for the trail. Defaults to `true`. Setting this to `false` will pause logging.
     */
    @JvmName("tftdtletgcfehdac")
    public suspend fun enableLogging(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableLogging = mapped
    }

    /**
     * @param value Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    @JvmName("wwvjkgpavsonaenp")
    public suspend fun eventSelectors(`value`: List<TrailEventSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSelectors = mapped
    }

    /**
     * @param argument Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    @JvmName("jvhlbnanakmhwpmb")
    public suspend
    fun eventSelectors(argument: List<suspend TrailEventSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrailEventSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSelectors = mapped
    }

    /**
     * @param argument Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    @JvmName("wjiyitgrirxldtcj")
    public suspend fun eventSelectors(
        vararg
        argument: suspend TrailEventSelectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrailEventSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSelectors = mapped
    }

    /**
     * @param argument Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    @JvmName("pcocvbrwdkqmajad")
    public suspend fun eventSelectors(argument: suspend TrailEventSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrailEventSelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventSelectors = mapped
    }

    /**
     * @param values Specifies an event selector for enabling data event logging. Fields documented below. Please note the [CloudTrail limits](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) when configuring these. Conflicts with `advanced_event_selector`.
     */
    @JvmName("eygyhxxeuswblmrb")
    public suspend fun eventSelectors(vararg values: TrailEventSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSelectors = mapped
    }

    /**
     * @param value Whether the trail is publishing events from global services such as IAM to the log files. Defaults to `true`.
     */
    @JvmName("oyjekcrhxnbdfxxh")
    public suspend fun includeGlobalServiceEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeGlobalServiceEvents = mapped
    }

    /**
     * @param value Configuration block for identifying unusual operational activity. See details below.
     */
    @JvmName("bihvsoxsowjofkka")
    public suspend fun insightSelectors(`value`: List<TrailInsightSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insightSelectors = mapped
    }

    /**
     * @param argument Configuration block for identifying unusual operational activity. See details below.
     */
    @JvmName("xvdtqcdrklinhtbb")
    public suspend
    fun insightSelectors(argument: List<suspend TrailInsightSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrailInsightSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insightSelectors = mapped
    }

    /**
     * @param argument Configuration block for identifying unusual operational activity. See details below.
     */
    @JvmName("axmohabgvowkcrbt")
    public suspend fun insightSelectors(
        vararg
        argument: suspend TrailInsightSelectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrailInsightSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insightSelectors = mapped
    }

    /**
     * @param argument Configuration block for identifying unusual operational activity. See details below.
     */
    @JvmName("matjawaktjqrforp")
    public suspend
    fun insightSelectors(argument: suspend TrailInsightSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrailInsightSelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.insightSelectors = mapped
    }

    /**
     * @param values Configuration block for identifying unusual operational activity. See details below.
     */
    @JvmName("xxeoxchbneemhwsb")
    public suspend fun insightSelectors(vararg values: TrailInsightSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insightSelectors = mapped
    }

    /**
     * @param value Whether the trail is created in the current region or in all regions. Defaults to `false`.
     */
    @JvmName("rggswlwriqeyfilj")
    public suspend fun isMultiRegionTrail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMultiRegionTrail = mapped
    }

    /**
     * @param value Whether the trail is an AWS Organizations trail. Organization trails log events for the master account and all member accounts. Can only be created in the organization master account. Defaults to `false`.
     */
    @JvmName("lyhbiubjkroxeilu")
    public suspend fun isOrganizationTrail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOrganizationTrail = mapped
    }

    /**
     * @param value KMS key ARN to use to encrypt the logs delivered by CloudTrail.
     */
    @JvmName("echdwmppkycrkwla")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the trail.
     */
    @JvmName("rdpwlmxtivpquyto")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the S3 bucket designated for publishing log files.
     * The following arguments are optional:
     */
    @JvmName("ahmnfwdokokessbt")
    public suspend fun s3BucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value S3 key prefix that follows the name of the bucket you have designated for log file delivery.
     */
    @JvmName("tmktxgyjrchrnjop")
    public suspend fun s3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyPrefix = mapped
    }

    /**
     * @param value Name of the Amazon SNS topic defined for notification of log file delivery.
     */
    @JvmName("xumotprukjnaofdp")
    public suspend fun snsTopicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicName = mapped
    }

    /**
     * @param value Map of tags to assign to the trail. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sdclkywwlrxvulnt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the trail. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("inglfpkwtcpidcah")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TrailArgs = TrailArgs(
        advancedEventSelectors = advancedEventSelectors,
        cloudWatchLogsGroupArn = cloudWatchLogsGroupArn,
        cloudWatchLogsRoleArn = cloudWatchLogsRoleArn,
        enableLogFileValidation = enableLogFileValidation,
        enableLogging = enableLogging,
        eventSelectors = eventSelectors,
        includeGlobalServiceEvents = includeGlobalServiceEvents,
        insightSelectors = insightSelectors,
        isMultiRegionTrail = isMultiRegionTrail,
        isOrganizationTrail = isOrganizationTrail,
        kmsKeyId = kmsKeyId,
        name = name,
        s3BucketName = s3BucketName,
        s3KeyPrefix = s3KeyPrefix,
        snsTopicName = snsTopicName,
        tags = tags,
    )
}
