@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.inputs

import com.pulumi.aws.cloudtrail.inputs.GetServiceAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceAccount.
 * @property region Name of the region whose AWS CloudTrail account ID is desired.
 * Defaults to the region from the AWS provider configuration.
 */
public data class GetServiceAccountPlainArgs(
    public val region: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudtrail.inputs.GetServiceAccountPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.inputs.GetServiceAccountPlainArgs =
        com.pulumi.aws.cloudtrail.inputs.GetServiceAccountPlainArgs.builder()
            .region(region?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceAccountPlainArgs].
 */
@PulumiTagMarker
public class GetServiceAccountPlainArgsBuilder internal constructor() {
    private var region: String? = null

    /**
     * @param value Name of the region whose AWS CloudTrail account ID is desired.
     * Defaults to the region from the AWS provider configuration.
     */
    @JvmName("jkakpcewfdvvnvrr")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    internal fun build(): GetServiceAccountPlainArgs = GetServiceAccountPlainArgs(
        region = region,
    )
}
