@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.inputs

import com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dataResources Configuration block for data events. See details below.
 * @property excludeManagementEventSources A set of event sources to exclude. Valid values include: `kms.amazonaws.com` and `rdsdata.amazonaws.com`. `include_management_events` must be set to`true` to allow this.
 * @property includeManagementEvents Whether to include management events for your trail. Defaults to `true`.
 * @property readWriteType Type of events to log. Valid values are `ReadOnly`, `WriteOnly`, `All`. Default value is `All`.
 */
public data class TrailEventSelectorArgs(
    public val dataResources: Output<List<TrailEventSelectorDataResourceArgs>>? = null,
    public val excludeManagementEventSources: Output<List<String>>? = null,
    public val includeManagementEvents: Output<Boolean>? = null,
    public val readWriteType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs> {
    override fun toJava(): com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs =
        com.pulumi.aws.cloudtrail.inputs.TrailEventSelectorArgs.builder()
            .dataResources(
                dataResources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .excludeManagementEventSources(
                excludeManagementEventSources?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .includeManagementEvents(includeManagementEvents?.applyValue({ args0 -> args0 }))
            .readWriteType(readWriteType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrailEventSelectorArgs].
 */
@PulumiTagMarker
public class TrailEventSelectorArgsBuilder internal constructor() {
    private var dataResources: Output<List<TrailEventSelectorDataResourceArgs>>? = null

    private var excludeManagementEventSources: Output<List<String>>? = null

    private var includeManagementEvents: Output<Boolean>? = null

    private var readWriteType: Output<String>? = null

    /**
     * @param value Configuration block for data events. See details below.
     */
    @JvmName("sowyomdfkartxeul")
    public suspend fun dataResources(`value`: Output<List<TrailEventSelectorDataResourceArgs>>) {
        this.dataResources = value
    }

    @JvmName("frvbyyddnqvxgppx")
    public suspend fun dataResources(vararg values: Output<TrailEventSelectorDataResourceArgs>) {
        this.dataResources = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for data events. See details below.
     */
    @JvmName("qfnhjpgqgjbiibnx")
    public suspend fun dataResources(values: List<Output<TrailEventSelectorDataResourceArgs>>) {
        this.dataResources = Output.all(values)
    }

    /**
     * @param value A set of event sources to exclude. Valid values include: `kms.amazonaws.com` and `rdsdata.amazonaws.com`. `include_management_events` must be set to`true` to allow this.
     */
    @JvmName("guxmwunvcihhmwfp")
    public suspend fun excludeManagementEventSources(`value`: Output<List<String>>) {
        this.excludeManagementEventSources = value
    }

    @JvmName("aolwmgnquxugdmkp")
    public suspend fun excludeManagementEventSources(vararg values: Output<String>) {
        this.excludeManagementEventSources = Output.all(values.asList())
    }

    /**
     * @param values A set of event sources to exclude. Valid values include: `kms.amazonaws.com` and `rdsdata.amazonaws.com`. `include_management_events` must be set to`true` to allow this.
     */
    @JvmName("hgkkaqebmgpsbsty")
    public suspend fun excludeManagementEventSources(values: List<Output<String>>) {
        this.excludeManagementEventSources = Output.all(values)
    }

    /**
     * @param value Whether to include management events for your trail. Defaults to `true`.
     */
    @JvmName("eutuaddcujesvvxy")
    public suspend fun includeManagementEvents(`value`: Output<Boolean>) {
        this.includeManagementEvents = value
    }

    /**
     * @param value Type of events to log. Valid values are `ReadOnly`, `WriteOnly`, `All`. Default value is `All`.
     */
    @JvmName("vlvrfkffgpbinkyq")
    public suspend fun readWriteType(`value`: Output<String>) {
        this.readWriteType = value
    }

    /**
     * @param value Configuration block for data events. See details below.
     */
    @JvmName("fqkiwgwhdwvadtvy")
    public suspend fun dataResources(`value`: List<TrailEventSelectorDataResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataResources = mapped
    }

    /**
     * @param argument Configuration block for data events. See details below.
     */
    @JvmName("rmbdyprxpwvyqndk")
    public suspend
    fun dataResources(argument: List<suspend TrailEventSelectorDataResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrailEventSelectorDataResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataResources = mapped
    }

    /**
     * @param argument Configuration block for data events. See details below.
     */
    @JvmName("yyocylewqrrjrgsn")
    public suspend fun dataResources(
        vararg
        argument: suspend TrailEventSelectorDataResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrailEventSelectorDataResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataResources = mapped
    }

    /**
     * @param argument Configuration block for data events. See details below.
     */
    @JvmName("jxhedpjicpuqbptt")
    public suspend
    fun dataResources(argument: suspend TrailEventSelectorDataResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TrailEventSelectorDataResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataResources = mapped
    }

    /**
     * @param values Configuration block for data events. See details below.
     */
    @JvmName("uealnkppauodxkdw")
    public suspend fun dataResources(vararg values: TrailEventSelectorDataResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataResources = mapped
    }

    /**
     * @param value A set of event sources to exclude. Valid values include: `kms.amazonaws.com` and `rdsdata.amazonaws.com`. `include_management_events` must be set to`true` to allow this.
     */
    @JvmName("vuotqowngyfykojl")
    public suspend fun excludeManagementEventSources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeManagementEventSources = mapped
    }

    /**
     * @param values A set of event sources to exclude. Valid values include: `kms.amazonaws.com` and `rdsdata.amazonaws.com`. `include_management_events` must be set to`true` to allow this.
     */
    @JvmName("dioxvexpkrmjcpnf")
    public suspend fun excludeManagementEventSources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludeManagementEventSources = mapped
    }

    /**
     * @param value Whether to include management events for your trail. Defaults to `true`.
     */
    @JvmName("ecssxvsprmrtcnel")
    public suspend fun includeManagementEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeManagementEvents = mapped
    }

    /**
     * @param value Type of events to log. Valid values are `ReadOnly`, `WriteOnly`, `All`. Default value is `All`.
     */
    @JvmName("poeljxmxrstuqrus")
    public suspend fun readWriteType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readWriteType = mapped
    }

    internal fun build(): TrailEventSelectorArgs = TrailEventSelectorArgs(
        dataResources = dataResources,
        excludeManagementEventSources = excludeManagementEventSources,
        includeManagementEvents = includeManagementEvents,
        readWriteType = readWriteType,
    )
}
