@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataResources Configuration block for data events. See details below.
 * @property excludeManagementEventSources A set of event sources to exclude. Valid values include: `kms.amazonaws.com` and `rdsdata.amazonaws.com`. `include_management_events` must be set to`true` to allow this.
 * @property includeManagementEvents Whether to include management events for your trail. Defaults to `true`.
 * @property readWriteType Type of events to log. Valid values are `ReadOnly`, `WriteOnly`, `All`. Default value is `All`.
 */
public data class TrailEventSelector(
    public val dataResources: List<TrailEventSelectorDataResource>? = null,
    public val excludeManagementEventSources: List<String>? = null,
    public val includeManagementEvents: Boolean? = null,
    public val readWriteType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudtrail.outputs.TrailEventSelector):
            TrailEventSelector = TrailEventSelector(
            dataResources = javaType.dataResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudtrail.kotlin.outputs.TrailEventSelectorDataResource.Companion.toKotlin(args0)
                })
            }),
            excludeManagementEventSources = javaType.excludeManagementEventSources().map({ args0 -> args0 }),
            includeManagementEvents = javaType.includeManagementEvents().map({ args0 -> args0 }).orElse(null),
            readWriteType = javaType.readWriteType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
